% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.DGEobj}
\alias{subset.DGEobj}
\title{Subset internal row or column data}
\usage{
\method{subset}{DGEobj}(x, ..., row, col, drop = FALSE, debug = FALSE)
}
\arguments{
\item{x}{A DGEobj}

\item{...}{Additional parameters}

\item{row}{Row index for the subset}

\item{col}{Col index for the subset}

\item{drop}{Included for compatibility only}

\item{debug}{(default = FALSE) Set to TRUE to get additional information on the console if subsetting a DGEobj fails with a dimension error.}
}
\value{
A DGEobj
}
\description{
Subset internal row or column data
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    exObj <- subset(exObj, 1:10, 5:50)

}
