% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lyapunov.R
\name{summary.lyapunov}
\alias{summary.lyapunov}
\title{Summary method for a lyapunov object}
\usage{
\method{summary}{lyapunov}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"lyapunov"} provided by \code{\link{lyapunov.max}}, \code{\link{lyapunov.spec}} or \code{\link{lyapunov}} functions.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
This function \code{summary.lyapunov} computes and returns a list of summary statistics of the results given in a \code{lyapunov} object using the components (list elements) from its argument.
}
\description{
summary method for class "lyapunov".
}
\examples{
## set.seed(34)
## Simulates time-series data from the Logistic map with chaos
## ts        <- DChaos::logistic.sim(n=1000, a=4)
## show(head(ts, 5))

## Summary method for a lyapunov object (only 1 method)
## jacobian <- DChaos::jacobian.net(data=ts, m=3:3, lag=1:1, timelapse="FIXED", h=2:10)
## exponent <- DChaos::lyapunov.spec(x=jacobian, blocking="BOOT", B=100, doplot=FALSE)
## summary(exponent)

## Summary method for a lyapunov object (> 1 method)
## exponent <- DChaos::lyapunov(ts, m=3:3, lag=1:1, timelapse="FIXED", h=2:10, w0maxit=100,
##                     wtsmaxit=1e6, pre.white=TRUE, lyapmethod="SLE", blocking="ALL",
##                     B=100, trace=1, seed.t=TRUE, seed=56666459, doplot=FALSE))
## summmary(exponent)
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
