% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_MainFunctions.R
\name{kernel.list}
\alias{kernel.list}
\title{Print a list of available kernels in the DCSmooth package}
\usage{
kernel.list(print = TRUE)
}
\arguments{
\item{print}{Logical value. Should the list be printed to the console? If
\code{TRUE} (the default), the list is printed to the console, if
\code{FALSE} the list of identifiers is returned from the function as
(surprise!) a list.}
}
\value{
If \code{print = FALSE}, a list is returned containing the kernel
 identifiers
}
\description{
Print a list of available kernels in the DCSmooth package
}
\section{Details}{

\code{kernel.list} is used to get a list of available kernels in the DCSmooth
 package. 
 
\code{kernel.list} prints a list of identifiers \code{kernel_id} of available
 kernels in the DCSmooth package. The available kernel types are "T": 
 truncated, "MW": Müller-Wang boundary correction, "M": Müller boundary
 correction.
}

\examples{
 # See vignette("DCSmooth") for further examples and explanation
 
 kernel.list()

}
\references{
Müller, H.-G. and Wang, J.-L. (1994). Hazard rate estimation under random
 censoring with varying kernels and bandwidths. Biometrics, 50:61-76.
 
 Müller, H.-G. (1991). Smooth optimum kernel estimators near endpoints.
 Biometrika, 78:521-530.
 
 Feng, Y. and Schäfer B. (2021). Boundary Modification in Local Regression.
 Working Papers CIE 144, Paderborn University.
}
\seealso{
\code{\link{kernel.assign}}
}
