\name{getConstraint}
\alias{getConstraint}
\title{
Function giving the linear constraint associated with the chosen peptide and overlapping frame. 
}
\description{
This function prints the linear constraint to which the chosen peptide in the reference frame \code{pep} is subject when condisering gene overlap with frameshift \code{frame}.
}
\usage{
getConstraint(pep, frame, code, pepList)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pep}{
A chosen n-peptide in the reference frame (with length n<=5 if \code{pepList} is generated by function \code{\link{build_data}}).
}
  \item{frame}{
The frameshift chosen  in \{-2, -1, 0, 1, 2\}.
}
  \item{code}{
The code used to translate codons into amino acids (which can be generated by function \code{\link{build_data}}).
}
  \item{pepList}{
A list of all the peptide of length 1, 2, 3, ...required by the graph traversal algorithm (which can be generated by function \code{\link{build_data}}).
}
}
\references{
Lebre and Gascuel, The combinatorics of overlapping genes 
(freely available from arXiv at: 

http://arxiv.org/abs/1602.04971). 
}
\seealso{
\code{\link{build_data}}
}
\author{
Sophie Lebre <sophie.lebre@umontpellier.fr>
}


\examples{
	\dontrun{
# 1) Build peptideList, used by function getConstraint.
mydata <- build_data()
aaList <- mydata$aaList
geneticCode <- mydata$geneticCode
peptideList <- mydata$peptideList

# 2) Ask for the constraint induced on a chosen peptide in a chosen overlapping frame

## amino acid contraints 
getConstraint("C", frame = -2, code=geneticCode, pepList=peptideList) 
getConstraint("D", frame = 1, code=geneticCode, pepList=peptideList)

## 3-peptide contraints
getConstraint("CWC",frame = -2, code=geneticCode, pepList=peptideList)

## 5-peptide contraints
getConstraint("CWCCC",frame = -2, code=geneticCode, pepList=peptideList)
	}
}
\keyword{print}
