% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.MinimizeFN.R
\name{MinimizeFN}
\alias{MinimizeFN}
\title{Combined metric strategy to minimize FN errors.}
\description{
Calculates if the positive class is the predicted one in any of
the metrics, otherwise, the instance is not considered to have the positive
class associated.
}
\seealso{
\code{\link{CombinedMetrics}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:CombinedMetrics]{D2MCS::CombinedMetrics}} -> \code{MinimizeFN}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MinimizeFN-new}{\code{MinimizeFN$new()}}
\item \href{#method-MinimizeFN-getFinalPrediction}{\code{MinimizeFN$getFinalPrediction()}}
\item \href{#method-MinimizeFN-clone}{\code{MinimizeFN$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="D2MCS" data-topic="CombinedMetrics" data-id="getRequiredMetrics"><a href='../../D2MCS/html/CombinedMetrics.html#method-CombinedMetrics-getRequiredMetrics'><code>D2MCS::CombinedMetrics$getRequiredMetrics()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimizeFN-new"></a>}}
\if{latex}{\out{\hypertarget{method-MinimizeFN-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimizeFN$new(required.metrics = c("MCC", "PPV"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{required.metrics}}{A \link{character} vector of length 1 with the
name of the required metrics.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimizeFN-getFinalPrediction"></a>}}
\if{latex}{\out{\hypertarget{method-MinimizeFN-getFinalPrediction}{}}}
\subsection{Method \code{getFinalPrediction()}}{
Function to obtain the final prediction based on different
metrics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimizeFN$getFinalPrediction(
  raw.pred,
  prob.pred,
  positive.class,
  negative.class
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw.pred}}{A \link{character} list of length greater than 2 with the
class value of the predictions made by the metrics.}

\item{\code{prob.pred}}{A \link{numeric} list of length greater than 2 with the
probability of the predictions made by the metrics.}

\item{\code{positive.class}}{A \link{character} with the value of the positive
class.}

\item{\code{negative.class}}{A \link{character} with the value of the negative
class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{logical} value indicating if the instance is predicted
as positive class or not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinimizeFN-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MinimizeFN-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimizeFN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
