% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.utility.GenericModelFit.R
\name{GenericModelFit}
\alias{GenericModelFit}
\title{Abstract class for defining model fitting method.}
\description{
Template to create a \code{\link[recipes]{recipe}} or
\code{\link{formula}} objects used in model training stage.
}
\seealso{
\code{\link{DefaultModelFit}}, \code{\link[caret]{train}}
}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GenericModelFit-new}{\code{GenericModelFit$new()}}
\item \href{#method-GenericModelFit-createFormula}{\code{GenericModelFit$createFormula()}}
\item \href{#method-GenericModelFit-createRecipe}{\code{GenericModelFit$createRecipe()}}
\item \href{#method-GenericModelFit-clone}{\code{GenericModelFit$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModelFit-new"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModelFit-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModelFit$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModelFit-createFormula"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModelFit-createFormula}{}}}
\subsection{Method \code{createFormula()}}{
The function is responsible of creating a
\code{\link{formula}} for M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModelFit$createFormula(instances, class.name, simplify = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instances}}{A \link{data.frame} containing the instances used to
create the recipe.}

\item{\code{class.name}}{A \link{character} vector representing the name of the
target class.}

\item{\code{simplify}}{A \link{logical} argument defining whether the formula
should be generated as simple as possible.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{formula}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModelFit-createRecipe"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModelFit-createRecipe}{}}}
\subsection{Method \code{createRecipe()}}{
The function is responsible of creating a
\code{\link[recipes]{recipe}} for M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModelFit$createRecipe(instances, class.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instances}}{A \link{data.frame} containing the instances used to
create the recipe.}

\item{\code{class.name}}{A \link{character} vector representing the name of the
target class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A object of class \code{\link[recipes]{recipe}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModelFit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModelFit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModelFit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
