% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossGEESP.R
\name{CrossGEESP}
\alias{CrossGEESP}
\title{Run a semi-parametric GEE model for data from a crossover experiment with
 repeated measures}
\source{
https://doi.org/10.1177/09622802231158736
}
\usage{
CrossGEESP(
  response,
  period,
  treatment,
  id,
  time,
  carry,
  covar = NULL,
  data,
  family = gaussian,
  correlation = "independence",
  formula = NULL,
  tol = 1e-04,
  niter = 100,
  nodes = NULL,
  Mv = 1
)
}
\arguments{
\item{response}{A character string specifying the name of the
response variable of the crossover experimental design}

\item{period}{A character string specifying the name of vector with the
observation period of the responses of  the crossover experimental design}

\item{treatment}{A character string specifying the name of vector with the
treatment applied at each observation of the crossover experimental design}

\item{id}{A  character string specifying the name of vector which identifies
the experimental units. The length of ‘id’
should be the same as the number of observations. Data are assumed to be sorted so
that observations on each cluster appear as contiguous rows in data. If data
is not sorted this way, the function will not identify the clusters correctly.
 If data is not sorted this way, a warning will be issued.}

\item{time}{A character string specifying the name of the vector with the
measurement time within each period}

\item{carry}{A vector of  character string specifying the name set of dummy
 variables that indicates the treatment applied
in the previous period of each experimental unit. They must be 0 in period 1}

\item{covar}{A vector of  character string specifying the name of possible
covariates of the crossover experimental design}

\item{data}{A data frame with all the variables of the crossover experimental design}

\item{family}{See corresponding documentation to \code{glm}}

\item{correlation}{a character string specifying the correlation structure.
 The following are permitted: "independence", "fixed", "stat_M_dep",
"non_stat_M_dep", "exchangeable", "AR-M" and "unstructured"}

\item{formula}{A formula related the response variable with the explanatory
variables. If it is \code{NULL}, formula
\code{response~period+treatment+carry+time+covar} will be evaluated.}

\item{tol}{the tolerance used in the fitting algorithm.}

\item{niter}{the maximum number of iterations.}

\item{nodes}{Number of nodes in the estimation of the splines.
By default, the base 2 logarithm of the number of observations per period is used.}

\item{Mv}{When correlation is "stat_M_dep", "non_stat_M_dep", or "AR-M"
then Mv must be specified.}
}
\value{
\code{QIC} The QIC of the model: The model are fitted by \code{geeglm}

\code{model} The model fitted by \code{geeglm}.

\code{graphs} The graphs estimated by splines.
In position 1 the graph of the effect of time appears and from then on,
it appears one for each carryover effect declared in the \code{carry} option.
The graphs are built with \code{ggplot2}, therefore they allow manipulation
of axes and other graphic parameters of that library.
}
\description{
Provides a GEE model for the data of a crossover design with S
sequences of T periods. There must be at least two observations of each
experimental unit in each period. The effect of time within period and
the possible carryover effects are modeled by means of splines.
}
\examples{
data(Arterial)

carrydata <- createCarry(data=Arterial, treatment = "Treatment",
                         period = "Period",id="Subject", carrySimple = FALSE)
data <- carrydata$data
carry <- carrydata$carryover
model1 <- CrossGEESP(response = "Pressure", treatment = "Treatment",
                    period = "Period", id="Subject", time="Time",
                    carry=carrydata$carryover,data=data,
                    correlation = "exchangeable")


model2 <- CrossGEESP(response = "Pressure", treatment = "Treatment",
                     period = "Period", id="Subject", time="Time",
                     carry=carrydata$carryover,data=data, correlation = "AR-M")


model1$QIC
model2$QIC
summary(model1$model)
summary(model2$model)

## Aproximate p-values for model 2

(pvalues <- 2 * pnorm(abs(coef(summary(model2$model))[,5]), lower.tail = FALSE))

model1$graph[[1]]
model1$graph[[2]]
plot <- model1$graph[[1]] + ggplot2::xlab("Time in minutes")+
ggplot2::ylab("Change in systolic blood pressure")
plot
}
\references{
Cruz Gutierrez NA, Melo OO, Martinez CA. Semiparametric generalized
 estimating equations for repeated measurements in cross-over designs.
  Statistical Methods in Medical Research, 2023;32(5):1033-1050.
}
