% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acti.R
\name{fitactf}
\alias{fitactf}
\title{Fit the AutoCorrelation Transformation Function}
\usage{
fitactf(actpnts, discrete = FALSE)
}
\arguments{
\item{actpnts}{estimated ACT points}

\item{discrete}{logical - is the marginal distribution discrete?}
}
\description{
Fits the ACTF (Autocorrelation Transformation Function) to the estimated points (\eqn{\rho_x, \rho_z}) using \code{nls}.
}
\examples{

library(CoSMoS)

## choose the marginal distribution as Pareto type II
## with corresponding parameters
dist <- 'paretoII'
distarg <- list(scale = 1, shape = .3)

## estimate rho 'x' and 'z' points using ACTI
p <- actpnts(margdist = dist, margarg = distarg, p0 = 0)

## fit ACTF
fit <- fitactf(p)

## plot the result
plot(fit)

}
