% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpectedValue_EstParmFunc.R
\name{ExpectedValue_EstParmFunc}
\alias{ExpectedValue_EstParmFunc}
\title{Obtaining the value of the Dirichlet parameters, the expected value and the variance.}
\usage{
ExpectedValue_EstParmFunc(Param.Estimates, especie)
}
\arguments{
\item{Param.Estimates}{Vector with the estimated parameters. This value is the output of the Estimate_Param_EstParmFunc function.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of this matrix is the one used as reference in the alr transformation that the model applies.}
}
\value{
Returns a list with:

\itemize{
  \item Dirichlet.Param:  Matrix. Matrix that contains at row i the Dirichlet parameter of the bacteria i at all time points.
  \item Expected.Value:  Matrix. Matrix that contains at row i the expected value of the bacteria i at all time points. The bacterias are placed at the same orden than in \code{especies}.
   \item Variance.Value:  Matrix. Matrix that contains at row i the variance of the bacteria i at all time points. The bacterias are placed at the same orden than in \code{especies}.
  }
}
\description{
This function calculates the value of the Dirichlet parameters, the expected value and the variance for the Dirich-gLV model.
}
\examples{


especie1=cbind(c(0.5,0.3,0.2), c(0.1,0.3,0.6))
tau1=0.4
parms1= cbind(c(0.1,0.2),c(-0.2,0.1),c(0.3,0.2))
parms11=c(tau1,as.vector( parms1))

ExpectedValue_EstParmFunc(parms11,especie1)
}
\references{
Creus-Martí, I. and Moya, A. and Santonja, F. J. (2018). A Statistical Model with a Lotka-Volterra Structure for Microbiota Data. Lucas Jodar, Juan Carlos Cortes and Luis Acedo,  Modelling or engineering and human behavior 2018, Instituto Universitario de Matematica Multidisciplinar. ISBN: 978-84-09-07541-6
}
