% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{setEmOptions}
\alias{setEmOptions}
\title{Set Expectation and Maximization options.}
\usage{
setEmOptions(emOptions = list(epsi = NULL, typeSmallEM = NULL, typeEM = NULL,
  nberSmallEM = NULL, nberIterations = NULL, nberMaxIterations = NULL,
  putThreshold = NULL))
}
\arguments{
  \item{emOptions}{A list of options needed by the Expectation and maximization algorithm :
    \itemize{
        \item{epsi : }{In [1e-5, 1e-20], it is the upper bound of the relative increase in the log-likelihood.}
        \item{typeSmallEM : }{In c(0, 1, 2) : 0 = classic EM, 1 = SEM, 2 = CEM.}
        \item{typeEM : }{In c(0, 1, 2) : 0 = classic EM, 1 = SEM, 2 = CEM.}
        \item{nberSmallEM : }{The number of random parameter points from which to perform \code{nberIterations} EM runs.}
        \item{nberIterations : }{The number of iterations for each small EM.}
        \item{nberMaxIterations : }{The maximum number of iterations if EM algorithm converge hardly.}
        \item{putThreshold : }{If \code{TRUE}, the probabilities of levels are assumed to be positive in all clusters.}
    }}
}
\description{
Set Expectation and Maximization options.
}
\details{
Use \code{setEmOptions()} to set all options to default.
}
\examples{
EmOptions()
setEmOptions(list(epsi = 1e-6))
EmOptions()
setEmOptions()	# To set default values
EmOptions()
}
\author{
Wilson Toussile.
}
\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable 	selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}
\seealso{
\code{\link{EmOptions}} for getting the current EM options.
}
\keyword{EM}

