% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_clustering_difference_boxplot}
\alias{plot_clustering_difference_boxplot}
\title{Clustering Method Stability Boxplot}
\usage{
plot_clustering_difference_boxplot(clustering_difference_object, text_size = 3)
}
\arguments{
\item{clustering_difference_object}{An object returned by the
`get_clustering_difference_object` method.}

\item{text_size}{The size of the labels above boxplots.}
}
\value{
A ggplot2 object with the EC consistency distributions. Higher
consistency indicates a more stable clustering.
}
\description{
Display EC consistency across clustering method and resolution
values. The `filtered` field of the object returned by the
`get_clustering_difference_object` method is used.
Above each boxplot, the number of clusters is displayed.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(runif(500*10), nrow = 500)
rownames(expr_matrix) = as.character(1:500)

adj_matrix = Seurat::FindNeighbors(expr_matrix,
    k.param = 10,
    nn.method = "rann",
    verbose = FALSE,
    compute.SNN = FALSE)$nn
clust_diff_obj = get_clustering_difference(graph_adjacency_matrix = adj_matrix,
    resolution = c(0.5, 1),
    n_repetitions = 10,
    algorithm = 1:2,
    verbose = FALSE)
plot_clustering_difference_boxplot(clust_diff_obj)
}
