% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusvis.R
\docType{package}
\name{ClusVis-package}
\alias{ClusVis-package}
\alias{ClusVis}
\title{Gaussian-Based Visualization of Gaussian and Non-Gaussian Model-Based Clustering.}
\description{
The main function for parameter inference is \link{clusvis}.
Moreover, specific functions  \link{clusvisVarSelLCM} and \link{clusvisMixmod} are implemented to visualize the results of the R package VarSelLCM and Rmixmod.
After parameter inference, visualization is done with function \link{plotDensityClusVisu}.
}
\details{
\tabular{ll}{
  Package: \tab ClusVis\cr
  Type: \tab Package\cr
  Version: \tab 1.1.0\cr
  Date: \tab 2018-04-18\cr
  License: \tab GPL-3\cr
  LazyLoad: \tab yes\cr
}
}
\examples{
\dontrun{

 ## First example: R package Rmixmod
 # Package loading
 require(Rmixmod)

 # Data loading (categorical data)
 data("congress")
 # Model-based clustering with 4 components
 set.seed(123)
 res <- mixmodCluster(congress[,-1], 4, strategy = mixmodStrategy(nbTryInInit = 500, nbTry=25))

 # Inference of the parameters used for results visualization
 # (specific for Rmixmod results)
 # It is better because probabilities of classification are generated
 # by using the model parameters
 resvisu <- clusvisMixmod(res)

 # Component interpretation graph
 plotDensityClusVisu(resvisu)

 # Scatter-plot of the observation memberships
 plotDensityClusVisu(resvisu,  add.obs = TRUE)


## Second example: R package Rmixmod
# Package loading
require(Rmixmod)
 
# Data loading (categorical data)
data(birds)

# Model-based clustering with 3 components
resmixmod <- mixmodCluster(birds, 3)

# Inference of the parameters used for results visualization (general approach)
# Probabilities of classification are not sampled from the model parameter,
# but observed probabilities of classification are used for parameter estimation
resvisu <- clusvis(log(resmixmod@bestResult@proba),
                   resmixmod@bestResult@parameters@proportions)

# Inference of the parameters used for results visualization
# (specific for Rmixmod results)
# It is better because probabilities of classification are generated
# by using the model parameters
resvisu <- clusvisMixmod(resmixmod)

# Component interpretation graph
plotDensityClusVisu(resvisu)

# Scatter-plot of the observation memberships
plotDensityClusVisu(resvisu,  add.obs = TRUE)

## Third example: R package VarSelLCM
# Package loading
require(VarSelLCM)

# Data loading (categorical data)
data("heart")
# Model-based clustering with 3 components
res <- VarSelCluster(heart[,-13], 3)

# Inference of the parameters used for results visualization
# (specific for VarSelLCM results)
# It is better because probabilities of classification are generated
# by using the model parameters
resvisu <- clusvisVarSelLCM(res)

# Component interpretation graph
plotDensityClusVisu(resvisu)

# Scatter-plot of the observation memberships
plotDensityClusVisu(resvisu,  add.obs = TRUE)
}
}
\author{
Biernacki, C. and Marbac, M. and Vandewalle, V.
}
\keyword{package}
