% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_Anomaly.R
\name{CST_Anomaly}
\alias{CST_Anomaly}
\title{Anomalies relative to a climatology along selected dimension with or without 
cross-validation}
\usage{
CST_Anomaly(
  exp = NULL,
  obs = NULL,
  dim_anom = "sdate",
  cross = FALSE,
  memb_dim = "member",
  memb = TRUE,
  dat_dim = c("dataset", "member"),
  filter_span = NULL,
  ftime_dim = "ftime",
  ncores = NULL
)
}
\arguments{
\item{exp}{An object of class \code{s2dv_cube} as returned by \code{CST_Start} 
function, containing the seasonal forecast experiment data in the element 
named \code{$data}.}

\item{obs}{An object of class \code{s2dv_cube} as returned by \code{CST_Start} 
function, containing the observed data in the element named \code{$data}.}

\item{dim_anom}{A character string indicating the name of the dimension 
along which the climatology will be computed. The default value is 'sdate'.}

\item{cross}{A logical value indicating whether cross-validation should be 
applied or not. Default = FALSE.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. It must be one dimension in 'exp' and 'obs'. If there is no 
member dimension, set NULL. The default value is 'member'.}

\item{memb}{A logical value indicating whether to subtract the climatology 
based on the individual members (TRUE) or the ensemble mean over all
members (FALSE) when calculating the anomalies. The default value is TRUE.}

\item{dat_dim}{A character vector indicating the name of the dataset and 
member dimensions. If there is no dataset dimension, it can be NULL.
The default value is "c('dataset', 'member')".}

\item{filter_span}{A numeric value indicating the degree of smoothing. This 
option is only available if parameter \code{cross} is set to FALSE.}

\item{ftime_dim}{A character string indicating the name of the temporal 
dimension where the smoothing with 'filter_span' will be applied. It cannot
be NULL if 'filter_span' is provided. The default value is 'ftime'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL. It will be used only when 
'filter_span' is not NULL.}
}
\value{
A list with two S3 objects, 'exp' and 'obs', of the class 
's2dv_cube', containing experimental and date-corresponding observational 
anomalies, respectively. These 's2dv_cube's can be ingested by other functions 
in CSTools.
}
\description{
This function computes the anomalies relative to a climatology 
computed along the selected dimension (usually starting dates or forecast 
time) allowing the application or not of crossvalidated climatologies. The 
computation is carried out independently for experimental and observational 
data products.
}
\examples{
mod <- 1 : (2 * 3 * 4 * 5 * 6 * 7)
dim(mod) <- c(dataset = 2, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
obs <- 1 : (1 * 1 * 4 * 5 * 6 * 7)
dim(obs) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
lon <- seq(0, 30, 5)
lat <- seq(0, 25, 5)
coords <- list(lon = lon, lat = lat)
exp <- list(data = mod, coords = coords)
obs <- list(data = obs, coords = coords)
attr(exp, 'class') <- 's2dv_cube'
attr(obs, 'class') <- 's2dv_cube'

anom <- CST_Anomaly(exp = exp, obs = obs, cross = FALSE, memb = TRUE)

}
\seealso{
\code{\link[s2dv]{Ano_CrossValid}}, \code{\link[s2dv]{Clim}} and 
\code{\link{CST_Start}}
}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}

Pena Jesus, \email{jesus.pena@bsc.es}
}
