% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Predictability.R
\name{Predictability}
\alias{Predictability}
\title{Computing scores of predictability using two dynamical proxies 
based on dynamical systems theory.}
\usage{
Predictability(dim, theta, ncores = NULL)
}
\arguments{
\item{dim}{An array of N named dimensions containing the local dimension as 
the output of CST_ProxiesAttractor or ProxiesAttractor.}

\item{theta}{An array of N named dimensions containing the inverse of the 
persistence 'theta' as the output of CST_ProxiesAttractor or ProxiesAttractor.}

\item{ncores}{The number of cores to use in parallel computation}
}
\value{
A list of length 2:
\itemize{
\item\code{pred.dim} {a list of two lists 'qdim' and 'pos.d'. The 'qdim' list
contains values of local dimension 'dim' divided by terciles: 
d1: lower tercile (high predictability), 
d2: middle tercile, 
d3: higher tercile (low predictability)
The 'pos.d' list contains the position of each tercile in parameter 'dim'}

\item\code{pred.theta} {a list of two lists 'qtheta' and 'pos.t'. 
The 'qtheta' list contains values of the inverse of persistence 'theta' 
divided by terciles: 
th1: lower tercile (high predictability), 
th2: middle tercile, 
th3: higher tercile (low predictability)
The 'pos.t' list contains the position of each tercile in parameter 'theta'}
}

dyn_scores values from 0 to 1. A dyn_score of 1 indicates the highest
predictability.
}
\description{
This function divides in terciles the two dynamical proxies 
computed with CST_ProxiesAttractor or ProxiesAttractor. These terciles will
be used to measure the predictability of the system in dyn_scores. When the
local dimension 'dim' is small and the inverse of persistence 'theta' is 
small the predictability is high, and viceversa.
}
\examples{
# Creating an example of matrix dat(time,grids):
m <- matrix(rnorm(2000) * 10, nrow = 50, ncol = 40)
names(dim(m)) <- c('time', 'grid')
# imposing a threshold
 quanti <-  0.90
# computing dyn_scores from parameters dim and theta of the attractor
attractor <- ProxiesAttractor(dat = m, quanti = 0.60)
predyn <- Predictability(dim = attractor$dim, theta = attractor$theta)
}
\references{
Faranda, D., Alvarez-Castro, M.C., Messori, G., Rodriguez, D., 
and Yiou, P. (2019). The hammam effect or how a warm ocean enhances large 
scale atmospheric predictability.Nature Communications, 10(1), 1316. 
DOI = https://doi.org/10.1038/s41467-019-09305-8 "

Faranda, D., Gabriele Messori and Pascal Yiou. (2017).
Dynamical proxies of North Atlantic predictability and extremes. 
Scientific Reports, 7-41278, 2017.
}
\author{
Carmen Alvarez-Castro, \email{carmen.alvarez-castro@cmcc.it}

Maria M. Chaves-Montero, \email{mdm.chaves-montero@cmcc.it}

Veronica Torralba, \email{veronica.torralba@cmcc.it}

Davide Faranda, \email{davide.faranda@lsce.ipsl.fr}
}
