% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_MultivarRMSE.R
\name{CST_MultivarRMSE}
\alias{CST_MultivarRMSE}
\title{Multivariate Root Mean Square Error (RMSE)}
\usage{
CST_MultivarRMSE(exp, obs, weight = NULL)
}
\arguments{
\item{exp}{a list of objects, one for each variable, of class \code{s2dv_cube} as returned by \code{CST_Anomaly} function, containing the anomaly of the seasonal forecast experiment data in the element named \code{$data}.}

\item{obs}{a list of objects, one for each variable (in the same order than the input in 'exp') of class \code{s2dv_cube} as returned by \code{CST_Anomaly} function, containing the observed anomaly data in the element named \code{$data}.}

\item{weight}{(optional) a vector of weight values to assign to each variable. If no weights are defined, a value of 1 is assigned to every variable.}
}
\value{
an object of class \code{s2dv_cube} containing the RMSE in the element \code{$data} which is an array with two datset dimensions equal to the 'dataset' dimension in the \code{exp$data} and \code{obs$data} inputs.  An array with dimensions: c(number of exp, number of obs, 1 (the multivariate RMSE value), number of lat, number of lon)
}
\description{
This function calculates the RMSE from multiple variables, as the mean of each variable's RMSE scaled by its observed standard deviation. Variables can be weighted based on their relative importance (defined by the user).
}
\examples{
# Creation of sample s2dverification objects. These are not complete
# s2dverification objects though. The Load function returns complete objects.
# using package zeallot is optional:
library(zeallot)
# Example with 2 variables
mod1 <- 1 : (1 * 3 * 4 * 5 * 6 * 7)
mod2 <- 1 : (1 * 3 * 4 * 5 * 6 * 7)
dim(mod1) <- c(dataset = 1, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
dim(mod2) <- c(dataset = 1, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
obs1 <- 1 : (1 * 1 * 4 * 5 * 6 * 7)
obs2 <- 1 : (1 * 1 * 4 * 5 * 6 * 7)
dim(obs1) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
dim(obs2) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
lon <- seq(0, 30, 5)
lat <- seq(0, 25, 5)
exp1 <- list(data = mod1, lat = lat, lon = lon, Datasets = "EXP1", 
            source_files = "file1", Variable = list('pre'))
attr(exp1, 'class') <- 's2dv_cube'
exp2 <- list(data = mod2, lat = lat, lon = lon, Datasets = "EXP2", 
            source_files = "file2", Variable = list('tas'))
attr(exp2, 'class') <- 's2dv_cube'
obs1 <- list(data = obs1, lat = lat, lon = lon, Datasets = "OBS1", 
            source_files = "file1", Variable = list('pre'))
attr(obs1, 'class') <- 's2dv_cube'
obs2 <- list(data = obs2, lat = lat, lon = lon, Datasets = "OBS2", 
            source_files = "file2", Variable = list('tas'))
attr(obs2, 'class') <- 's2dv_cube'

c(ano_exp1, ano_obs1) \%<-\% CST_Anomaly(exp1, obs1, cross = TRUE, memb = TRUE)
c(ano_exp2, ano_obs2) \%<-\% CST_Anomaly(exp2, obs2, cross = TRUE, memb = TRUE)
ano_exp <- list(exp1, exp2)
ano_obs <- list(ano_obs1, ano_obs2)
weight <- c(1, 2)
a <- CST_MultivarRMSE(exp = ano_exp, obs = ano_obs, weight = weight)
str(a)
}
\seealso{
\code{\link[s2dv]{RMS}} and \code{\link{CST_Load}}
}
\author{
Deborah Verfaillie, \email{deborah.verfaillie@bsc.es}
}
