% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_cate.R
\name{estimate_cate}
\alias{estimate_cate}
\title{Estimate the Conditional Average Treatment Effect}
\usage{
estimate_cate(rules_matrix, rules_explicit, ite, B = 1, subsample = 1)
}
\arguments{
\item{rules_matrix}{A rules matrix.}

\item{rules_explicit}{A list of select rules in terms of covariate names.}

\item{ite}{The estimated ITEs.}

\item{B}{The number of bootstrap samples for uncertainty quantification in
estimation.}

\item{subsample}{The bootstrap ratio subsample for uncertainty quantification
in estimation.}
}
\value{
A list with 2 elements:
\code{summary}: A data frame summarizing the CATE linear decomposition:
\itemize{
\item \code{Rule}: rule name,
\item \code{Estimate}: linear contribution to CATE,
\item \code{CI_lower}: lower bound 95\% confidence interval on the estimate,
\item \code{CI_upper}: upper bound 95\% confidence interval on the estimate,
\item \code{P_Value}: p-value (from Z-test).
\code{model}: A linear model for CATE-ATE estimation.
}
}
\description{
Estimates the Conditional Average Treatment Effect (CATE) by
linearly modeling the Individual Treatment Effect by a set of rules.
}
\keyword{internal}
