% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_pillar_04kv.R
\name{financial_cof_pillar_04kv}
\alias{financial_cof_pillar_04kv}
\title{Financial cost of Failure for 0.4kV Pillar}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_pillar_04kv(
  type_financial_factor_criteria = "Asbestos clad",
  access_factor_criteria
)
}
\arguments{
\item{type_financial_factor_criteria}{String Type Financial factor criteria for 0.4kV Pillar
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{type_financial_factor_criteria = c("Non Asbestos clad", "Asbestos clad")}.}

\item{access_factor_criteria}{String. Asses Financial factor criteria for 0.4kV Pillar
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B", "Type C")}.}
}
\value{
Numeric. Financial consequences of failure for 0.4kV Pillar
}
\description{
This function calculates financial consequences of failure
Financial consequences of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
Outputted in DKK.
}
\examples{
financial_cof_pillar_04kv(
type_financial_factor_criteria = "Asbestos clad",
 access_factor_criteria = "Type A")
}
