% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PostProcess.R
\name{bestApproximateMinimizers}
\alias{bestApproximateMinimizers}
\title{bestApproximateMinimizers}
\usage{
bestApproximateMinimizers(CGNM_result, numParameterSet = 1)
}
\arguments{
\item{CGNM_result}{(required input) \emph{A list} stores the computational result from Cluster_Gauss_Newton_method() function in CGNM package.}

\item{numParameterSet}{(default 1) \emph{A natural number} number of parameter sets to output (chosen from the smallest SSR to numParameterSet-th smallest SSR) .}
}
\value{
\emph{A vector} a vector of accepted approximate minimizers with minimum SSR found by CGNM.
}
\description{
Returns the approximate minimizers with minimum SSR found by CGNM.
}
\examples{

model_analytic_function=function(x){

 observation_time=c(0.1,0.2,0.4,0.6,1,2,3,6,12)
 Dose=1000
 F=1

 ka=x[1]
 V1=x[2]
 CL_2=x[3]
 t=observation_time

 Cp=ka*F*Dose/(V1*(ka-CL_2/V1))*(exp(-CL_2/V1*t)-exp(-ka*t))

 log10(Cp)
}

observation=log10(c(4.91, 8.65, 12.4, 18.7, 24.3, 24.5, 18.4, 4.66, 0.238))

CGNM_result=Cluster_Gauss_Newton_method(
nonlinearFunction=model_analytic_function,
targetVector = observation,
initial_lowerRange = c(0.1,0.1,0.1), initial_upperRange =  c(10,10,10),
num_iter = 10, num_minimizersToFind = 100)

bestApproximateMinimizers(CGNM_result,10)
}
