% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellTypeFraction.R
\name{Identify_ConservedCellTypes}
\alias{Identify_ConservedCellTypes}
\title{Identify conserved cell types based on power of genes and orthologs database}
\usage{
Identify_ConservedCellTypes(
  OrthG,
  Species1_Marker_table,
  Species2_Marker_table,
  Species_name1,
  Species_name2
)
}
\arguments{
\item{OrthG}{ortholog genes database}

\item{Species1_Marker_table}{data.frame of species 1, should contain three column:
'gene', 'cluster' and 'power'}

\item{Species2_Marker_table}{data.frame of species 2, should contain three column:
'gene', 'cluster' and 'power'}

\item{Species_name1}{character, indicating the species names of Species1_Marker_table}

\item{Species_name2}{character, indicating the species names of Species2_Marker_table}
}
\value{
list contains two elements: first one is details of conserved cell types,
second one is matrix of cell types conserved score
}
\description{
Identify conserved cell types based on power of genes and orthologs database
}
\examples{
load(system.file("extdata", "CellTypeAllMarkers.rda", package = "CACIMAR"))
expression <- Identify_ConservedCellTypes(OrthG_Mm_Zf,mm_Marker[1:30,],zf_Marker[1:30,],'mm','zf')
}
