% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covsum_nested.R
\name{covsum_nested}
\alias{covsum_nested}
\title{Nested version of reportRmd covsum()}
\usage{
covsum_nested(
  data,
  covs,
  maincov = NULL,
  id = NULL,
  digits = 1,
  numobs = NULL,
  markup = TRUE,
  sanitize = TRUE,
  nicenames = FALSE,
  IQR = FALSE,
  all.stats = FALSE,
  pvalue = TRUE,
  effSize = TRUE,
  show.tests = TRUE,
  nCores = NULL,
  nested.test = NULL,
  nsim = NULL,
  excludeLevels = NULL,
  dropLevels = TRUE,
  full = TRUE,
  digits.cat = 0,
  testcont = c("rank-sum test", "ANOVA"),
  testcat = c("Chi-squared", "Fisher"),
  include_missing = FALSE,
  percentage = c("column", "row")
)
}
\arguments{
\item{data}{dataframe containing data}

\item{covs}{character vector with the names of columns to include in table}

\item{maincov}{covariate to stratify table by}

\item{id}{covariates to nest summary by}

\item{digits}{number of digits for summarizing mean data, does not affect
p-values}

\item{numobs}{named list overriding the number of people you expect to have
the covariate}

\item{markup}{boolean indicating if you want latex markup}

\item{sanitize}{boolean indicating if you want to sanitize all strings to not
break LaTeX}

\item{nicenames}{boolean indicating if you want to replace . and _ in strings
with a space}

\item{IQR}{boolean indicating if you want to display the inter quantile range
(Q1,Q3) as opposed to (min,max) in the summary for continuous variables}

\item{all.stats}{boolean indicating if all summary statistics (Q1,Q3 +
min,max on a separate line) should be displayed. Overrides IQR.}

\item{pvalue}{boolean indicating if you want p-values included in the table}

\item{effSize}{boolean indicating if you want effect sizes included in the
table. Can only be obtained if pvalue is also requested.}

\item{show.tests}{boolean indicating if the type of statistical used should
be shown in a column beside the p-values. Ignored if pvalue=FALSE.}

\item{nCores}{if > 1, specifies number of cores to use for parallel processing
for calculating the nested p-value (default: 1).}

\item{nested.test}{specifies test used for calculating nested p-value from
afex::mixed function. Either \emph{parametric bootstrap} method
or \emph{likelihood ratio test} method (default: "LRT"). Parametric bootstrap
takes longer.}

\item{nsim}{specifies number of simulations to use for calculating nested p-value
with \emph{parametric bootstrap} method used for nested.test (default: 1000).}

\item{excludeLevels}{a named list of covariate levels to exclude from
statistical tests in the form list(varname =c('level1','level2')). These
levels will be excluded from association tests, but not the table. This can
be useful for levels where there is a logical skip (i.e. not missing, but not
presented). Ignored if pvalue=FALSE.}

\item{dropLevels}{logical, indicating if empty factor levels be dropped from
the output, default is TRUE.}

\item{full}{boolean indicating if you want the full sample included in the
table, ignored if maincov is NULL}

\item{digits.cat}{number of digits for the proportions when summarizing
categorical data (default: 0)}

\item{testcont}{test of choice for continuous variables,one of
\emph{rank-sum} (default) or \emph{ANOVA}}

\item{testcat}{test of choice for categorical variables,one of
\emph{Chi-squared} (default) or \emph{Fisher}}

\item{include_missing}{Option to include NA values of maincov. NAs will not
be included in statistical tests}

\item{percentage}{choice of how percentages are presented, one of
\emph{column} (default) or \emph{row}}
}
\description{
Nested version of reportRmd covsum()
}
\seealso{
\code{\link{fisher.test}},\code{\link{chisq.test}},
\code{\link{wilcox.test}},\code{\link{kruskal.test}}, and
\code{\link{anova}}
}
