% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compilation_surface_fuels.R
\name{CompileSurfaceFuels}
\alias{CompileSurfaceFuels}
\title{CompileSurfaceFuels}
\usage{
CompileSurfaceFuels(
  fwd_data = "none",
  cwd_data = "none",
  design,
  wt_data = "not_needed",
  fpc_data = "not_needed",
  units = "metric"
)
}
\arguments{
\item{fwd_data}{A dataframe or tibble. Fine woody debris (FWD) loads must already be calculated at the plot-level using the FineFuels function. Required columns depend on the sampling design:
\itemize{
\item Simple random sampling: must have time, site, plot, sc_length_1h, sc_length_10h, and sc_length_100h columns. Must also have load_1h_Mg_ha, load_10h_Mg_ha, and load_100h_Mg_ha (OR load_1h_ton_ac, load_10h_ton_ac, and load_100h_ton_ac).
\item Stratified random sampling: must have time, site, stratum, plot, sc_length_1h, sc_length_10h, and sc_length_100h columns. Must also have load_1h_Mg_ha, load_10h_Mg_ha, and load_100h_Mg_ha (OR load_1h_ton_ac, load_10h_ton_ac, and load_100h_ton_ac).
\item Fire and Fire Surrogate: must have time, trt_type, site, plot, sc_length_1h, sc_length_10h, and sc_length_100h columns. Must also have load_1h_Mg_ha, load_10h_Mg_ha, and load_100h_Mg_ha (OR load_1h_ton_ac, load_10h_ton_ac, and load_100h_ton_ac).
}}

\item{cwd_data}{A dataframe or tibble. Coarse woody debris (CWD) loads must already be calculated at the plot-level using the CoarseFuels function. Required columns depend on the sampling design:
\itemize{
\item Simple random sampling: must have time, site, plot, sc_length_1000s, and sc_length_1000r columns. Must also have load_1000s_Mg_ha, load_1000r_Mg_ha, and load_cwd_Mg_ha (OR load_1000s_Mg_ha, load_1000r_Mg_ha, and load_cwd_Mg_ha).
\item Stratified random sampling: must have time, site, stratum, plot, sc_length_1000s, and sc_length_1000r columns. Must also have load_1000s_Mg_ha, load_1000r_Mg_ha, and load_cwd_Mg_ha (OR load_1000s_Mg_ha, load_1000r_Mg_ha, and load_cwd_Mg_ha).
\item Fire and Fire Surrogate: must have time, trt_type, site, plot, sc_length_1000s, and sc_length_1000r columns. Must also have load_1000s_Mg_ha, load_1000r_Mg_ha, and load_cwd_Mg_ha (OR load_1000s_Mg_ha, load_1000r_Mg_ha, and load_cwd_Mg_ha).
}}

\item{design}{Specifies the sampling design. Must be set to "SRS" (simple random sample), "STRS" (stratified ransom sample), or "FFS" (Fire and Fire Surrogate). There is no default.}

\item{wt_data}{Only required for stratified random sampling designs. A dataframe or tibble with the following columns: time (optional), site, stratum, and wh (stratum weight). The default is set to "not_needed", and should be left as such for design = "SRS" or design = "FFS".}

\item{fpc_data}{An optional dataframe or tibble. Incorporates the finite population correction factor (FPC) when samples were taken without replacement. The default is set to "not_needed". Required columns depend on the sampling design:
\itemize{
\item Simple random sampling: must have site, N, and n columns. A time column is optional.
\item Stratified random sampling: must have site, stratum, N, and n columns. A time column is optional.
\item Fire and Fire Surrogate: must have trt_type, site, N and n columns. A time column in optional.
}}

\item{units}{Specifies whether the input data are in metric (megagrams per hectare) or imperial (US tons per acre) units. Inputs must be all metric or all imperial (do not mix-and-match units). The output units will match the input units (i.e., if inputs are in metric then outputs will be in metric). Must be set to either “metric” or “imperial”. The default is set to “metric”.}
}
\value{
Depends on the sampling design:
\itemize{
\item Simple random sampling: a dataframe with site-level summaries.
\item Stratified random sampling: a list with two components: (1) a dataframe with stratum-level summaries and (2) a dataframe with site-level summaries.
\item Fire and Fire Surrogate: a list with two components: (1) a dataframe with site-level (i.e., compartment-level) summaries and (2) a dataframe with treatment-level summaries.
}
}
\description{
Compiles surface fuel data beyond the plot level. Specifically designed to further summarize outputs from the FineFuels and/or CoarseFuels functions. Recognizes simple random sampling and stratified random sampling designs. Also recognizes the design of the Fire and Fire Surrogate. See \href{https://github.com/kearutherford/BerkeleyForestsAnalytics/tree/main}{README} for details.
}
\examples{
CompileSurfaceFuels(fwd_data = compilation_fwd_demo,
                    cwd_data = compilation_cwd_demo,
                    design = "STRS",
                    wt_data = compilation_wt_demo,
                    fpc_data = "not_needed",
                    units = "metric")

CompileSurfaceFuels(fwd_data = compilation_fwd_demo,
                    cwd_data = "none",
                    design = "STRS",
                    wt_data = compilation_wt_demo,
                    fpc_data = "not_needed",
                    units = "metric")

}
