/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.SitePatterns;
import dr.evolution.alignment.TaxaFilteredSitePatterns;
import dr.evolution.util.Taxon;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class TaxaFilteredSitePatternsParser
extends AbstractXMLObjectParser {
    private static final String PATTERNS = "taxaFilteredPatterns";
    private static final String OPERATION = "operation";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("operation"), new ElementRule(SitePatterns.class), new ElementRule(Taxon.class)};

    @Override
    public String getParserName() {
        return PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        SitePatterns sitePatterns = (SitePatterns)xMLObject.getChild(SitePatterns.class);
        Taxon taxon = (Taxon)xMLObject.getChild(Taxon.class);
        String string = xMLObject.getStringAttribute(OPERATION);
        ArrayList<Taxon> arrayList = null;
        ArrayList<Taxon> arrayList2 = null;
        if (string.equalsIgnoreCase("include")) {
            arrayList = new ArrayList<Taxon>();
            arrayList.add(taxon);
        } else if (string.equalsIgnoreCase("exclude")) {
            arrayList2 = new ArrayList<Taxon>();
            arrayList2.add(taxon);
        } else {
            throw new XMLParseException("Unknown operation");
        }
        return new TaxaFilteredSitePatterns(sitePatterns, arrayList, arrayList2);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A filtered site pattern list";
    }

    @Override
    public Class getReturnType() {
        return TaxaFilteredSitePatterns.class;
    }
}

