/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.operators;

import dr.evomodel.coalescent.GMRFSkyrideLikelihood;
import dr.evomodel.coalescent.operators.GMRFSkyrideBlockUpdateOperator;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.MultivariateDistribution;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import no.uib.cipr.matrix.UpperSPDDenseMatrix;

public class GMRFSkyrideFixedEffectsGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private GMRFSkyrideLikelihood gmrfLikelihood;
    private DenseVector mean;
    private DenseMatrix precision;
    private int fieldLength;
    private int dim;

    public GMRFSkyrideFixedEffectsGibbsOperator(Parameter parameter, GMRFSkyrideLikelihood gMRFSkyrideLikelihood, MultivariateDistribution multivariateDistribution, double d) {
        this.gmrfLikelihood = gMRFSkyrideLikelihood;
        this.mean = new DenseVector(multivariateDistribution.getMean());
        this.precision = new DenseMatrix(multivariateDistribution.getScaleMatrix());
        this.fieldLength = gMRFSkyrideLikelihood.getPopSizeParameter().getDimension();
        this.dim = parameter.getDimension();
        this.gmrfLikelihood = gMRFSkyrideLikelihood;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        DenseMatrix denseMatrix = new DenseMatrix(this.gmrfLikelihood.getDesignMatrix().getParameterAsMatrix());
        SymmTridiagMatrix symmTridiagMatrix = this.gmrfLikelihood.getScaledWeightMatrix(this.gmrfLikelihood.getPrecisionParameter().getParameterValue(0), this.gmrfLikelihood.getLambdaParameter().getParameterValue(0));
        DenseVector denseVector = new DenseVector(this.gmrfLikelihood.getPopSizeParameter().getParameterValues());
        Parameter.Abstract abstract_ = (Parameter.Abstract)this.gmrfLikelihood.getBetaParameter();
        DenseMatrix denseMatrix2 = this.precision.copy();
        DenseVector denseVector2 = new DenseVector(this.dim);
        DenseMatrix denseMatrix3 = new DenseMatrix(this.dim, this.fieldLength);
        DenseVector denseVector3 = new DenseVector(this.dim);
        denseMatrix.transAmultAdd(symmTridiagMatrix, denseMatrix3);
        denseMatrix3.multAdd(denseMatrix, denseMatrix2);
        this.precision.mult(this.mean, denseVector3);
        denseMatrix3.multAdd(denseVector, denseVector3);
        denseMatrix3 = Matrices.identity(this.dim);
        denseMatrix2.solve(Matrices.identity(this.dim), denseMatrix3);
        UpperSPDDenseMatrix upperSPDDenseMatrix = new UpperSPDDenseMatrix(denseMatrix3);
        upperSPDDenseMatrix.mult(denseVector3, denseVector2);
        DenseVector denseVector4 = GMRFSkyrideBlockUpdateOperator.getMultiNormal(denseVector2, upperSPDDenseMatrix);
        for (int i = 0; i < this.dim; ++i) {
            abstract_.setParameterValueQuietly(i, denseVector4.get(i));
        }
        abstract_.fireParameterChangedEvent();
        return 0.0;
    }

    public int getStepCount() {
        return 0;
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public final String getOperatorName() {
        return "gmrfFixedEffectsGibbsOperator";
    }
}

