% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_designs.R
\name{BLE_Ratio}
\alias{BLE_Ratio}
\title{Ratio BLE}
\source{
\url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X201400111886}
}
\usage{
BLE_Ratio(ys, xs, x_nots, m = NULL, v = NULL, sigma = NULL)
}
\arguments{
\item{ys}{vector of sample observations.}

\item{xs}{vector with values for the auxiliary variable of the elements in the sample.}

\item{x_nots}{vector with values for the auxiliary variable of the elements not in the sample.}

\item{m}{prior mean for the ratio between Y and X. If NULL, \code{mean(ys)/mean(xs)} will be used (non-informative prior).}

\item{v}{prior variance of the ratio between Y and X (bigger than sigma^2). If NULL, it will tend to infinity (non-informative prior).}

\item{sigma}{prior estimate of variability (standard deviation) of the ratio within the population. If NULL, sample variance of the ratio will be used.}
}
\value{
A list containing the following components: \itemize{
\item \code{est.beta} - BLE of Beta
\item \code{Vest.beta} - Variance associated with the above
\item \code{est.mean} - BLE for each individual not in the sample
\item \code{Vest.mean} - Covariance matrix associated with the above
\item \code{est.tot} - BLE for the total
\item \code{Vest.tot} - Variance associated with the above
}
}
\description{
Creates the Bayes Linear Estimator for the Ratio "estimator"
}
\examples{
ys <- c(10,8,6)
xs <- c(5,4,3)
x_nots <- c(1,20)
m <- 2
v <- 10
sigma <- 2

Estimator <- BLE_Ratio(ys,xs,x_nots,m,v,sigma)
Estimator
}
\references{
Gonçalves, K.C.M, Moura, F.A.S and  Migon, H.S.(2014). Bayes Linear Estimation for Finite Population with emphasis on categorical data. Survey Methodology, 40, 15-28.
}
