% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yyy.R
\docType{data}
\name{d_sim_binom_cov}
\alias{d_sim_binom_cov}
\alias{d_sim_binom_cov_hgly2}
\title{Sample simulated data for exposure-response with binary endpoint.}
\format{
A data frame with columns:
\describe{
\item{ID}{Subject ID}
\item{AETYPE}{Adverse event type: hgly2 (Gr2+ hyperglycemia),
dr2 (Gr2+ Diarrhea), ae_covsel_test (hypothetical AE for covariate
selection function test)}
\item{AEFLAG}{Adverse event flag: 0 - no event, 1 - event}
\item{Dose_mg}{Dose in mg: 200, 400}
\item{AUCss}{Steady-state area under the curve}
\item{Cmaxss}{Steady-state maximum (peak) concentration}
\item{Cminss}{Steady-state minimum (trough) concentration}
\item{BAGE}{Baseline age in years}
\item{BWT}{Baseline weight in kg}
\item{BGLUC}{Baseline glucose in mmol/L}
\item{BHBA1C}{Baseline HbA1c in percentage}
\item{RACE}{Race: White, Black, Asian}
\item{VISC}{Visceral disease: No, Yes}
\item{AUCss_1000}{AUCss/1000}
\item{BAGE_10}{BAGE/10}
\item{BWT_10}{BWT/10}
\item{BHBA1C_5}{BHBA1C/5}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 500 rows and 17 columns.
}
\usage{
d_sim_binom_cov

d_sim_binom_cov_hgly2
}
\description{
Sample simulated data for exposure-response with binary endpoint.
}
\details{
This simulated dataset is very loosely inspired by ER analysis of
ipatasertib by Kotani (2022) at:

https://doi.org/10.1007/s00280-022-04488-2

You can find the data generating code in the package source code,
under \code{data-raw/d_sim_binom_cov.R}.

d_sim_binom_cov_hgly2 is a subset of this dataset with only hgly2 AE type
and some columns added for testing.
}
\examples{
d_sim_binom_cov
d_sim_binom_cov_hgly2
}
\keyword{datasets}
