% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variability.R
\name{variability}
\alias{variability}
\title{Variability analysis}
\usage{
variability(data, data.var, size.var, VC = TRUE, weight = FALSE)
}
\arguments{
\item{data}{a data frame.}

\item{data.var}{a vector of variable names or of column numbers defining (numeric) variables whose variability will be analyzed by \code{variability}.}

\item{size.var}{a vector of variable names or of column numbers defining variables for weights (active only if \code{weight=TRUE}).}

\item{VC}{logical; if \code{TRUE}, calculates variation coefficients of variables in \code{data.var}.}

\item{weight}{logical; if TRUE, calculates weighted variation coefficients and standard deviations.}
}
\value{
A list with the following elements: ranges, standard deviations, variation coefficients, and two dataframes (data, size).
}
\description{
Variability analysis
}
\examples{
Pbox.BC <- subset(Pbox, Team=="Oklahoma City Thunder" & MIN >= 500,
                    select=c("P2p","P3p","FTp","P2A","P3A","FTA"))
list_variability <- variability(data=Pbox.BC, data.var=c("P2p","P3p","FTp"),
                                size.var=c("P2A","P3A","FTA"), weight=TRUE)
print(list_variability)
plot(list_variability, leg.brk=c(10,25,50,100,500,1000), max.circle=30)
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
