% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,jumpDiffusion-method}
\alias{simulate,jumpDiffusion-method}
\title{Simulation of jump diffusion process}
\usage{
\S4method{simulate}{jumpDiffusion}(object, nsim = 1, seed = NULL, t, y0,
  start = c(0, 0), mw = 1, plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "jumpDiffusion"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{y0}{starting point of process}

\item{start}{vector: start[1] starting point time, start[2] starting point for Poisson process}

\item{mw}{mesh width for finer Euler approximation to simulate time-continuity}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of jump diffusion process
  \eqn{dY_t = b(\phi,t,Y_t)dt + s(\gamma,t,Y_t)dW_t + h(\eta,t,Y_t)dN_t}.
}
\examples{
model <- set.to.class("jumpDiffusion",
   parameter = list(theta = 0.1, phi = 0.05, gamma2 = 0.1, xi = c(3, 1/4)),
   Lambda = function(t, xi) (t/xi[2])^xi[1])
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5)
}

