% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{Diffusion-class}
\alias{Diffusion-class}
\title{S4 class of model informations for diffusion process}
\description{
Informations of model
\eqn{dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t}.
}
\section{Slots}{

\describe{
\item{\code{phi}}{parameter \eqn{\phi}}

\item{\code{gamma2}}{parameter \eqn{\gamma^2}}

\item{\code{b.fun}}{function \eqn{b(\phi,t,y)}}

\item{\code{sT.fun}}{function \eqn{\widetilde{s}(t,y)}}

\item{\code{prior}}{list of prior parameters}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
parameter <- list(phi = 0.1, gamma2 = 0.01)
b.fun <- function(phi, t, y) phi * y
sT.fun <- function(t, y) y
start <- parameter
prior <- list(m.phi = parameter$phi, v.phi = parameter$phi^2,
   alpha.gamma = 3, beta.gamma = 2*parameter$gamma2)
model <- set.to.class("Diffusion", parameter, prior, start,
  b.fun = b.fun, sT.fun = sT.fun)
}

