% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,hiddenDiffusion-method}
\alias{simulate,hiddenDiffusion-method}
\title{Simulation of hidden diffusion process}
\usage{
\S4method{simulate}{hiddenDiffusion}(object, nsim = 1, seed = NULL, t,
  mw = 10, plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "hiddenDiffusion"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{mw}{mesh width for finer Euler approximation to simulate time-continuity}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of a hidden stochastic process model
  \eqn{Z_i = Y_{t_i} + \epsilon_i, dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t,
  \epsilon_i\sim N(0,\sigma^2), Y_{t_0}=y_0(\phi, t_0)}.
}
\examples{
model <- set.to.class("hiddenDiffusion", parameter = list(phi = 0.5, gamma2 = 0.01, sigma2 = 0.1))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
}

