\name{get.oc.comb}
\alias{get.oc.comb}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Generate operating characteristics for drug combination trials
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Obtain the operating characteristics of the BOIN design for drug combination trials 
}
\usage{
get.oc.comb(target, p.true, ncohort, cohortsize, n.earlystop=100, 
startdose=c(1, 1), p.saf="default", p.tox="default", cutoff.eli=0.95, 
extrasafe=FALSE, offset=0.05, ntrial=1000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{target}{
%%     ~~Describe \code{target} here~~
target toxicity rate
}
  \item{p.true}{
%%     ~~Describe \code{p.true} here~~
a \code{JxK} matrix containing the true toxicity probabilities of combinations with \code{J} dose levels of agent A and \code{K} dose levels of agent B.
}
  \item{ncohort}{
%%     ~~Describe \code{ncohort} here~~
the total number of cohorts
}
  \item{cohortsize}{
%%     ~~Describe \code{cohortsize} here~~
the cohort size
}
 \item{n.earlystop}{
%%     ~~Describe \code{ndmax} here~~
Early stopping parameter. If the number of patients treated at the current dose reaches \code{n.earlystop}, stop the trial and select the MTD based on the observed data. The default value \code{n.earlystop=100} essentially turns off this type of early stopping. 
}
  \item{startdose}{
%%     ~~Describe \code{startdose} here~~
the starting dose combination level for the trial
}
  \item{p.saf}{
%%     ~~Describe \code{p.saf} here~~
the highest toxicity probability that is deemed subtherapeutic (i.e. below the MTD) such that dose escalation should be undertaken. The default value is \code{p.saf=0.6 x target}.}
  \item{p.tox}{
%%     ~~Describe \code{p.tox} here~~
the lowest toxicity probability that is deemed overly toxic such that deescalation is required. The default value is \code{p.tox=1.4 x target}.
}
  \item{cutoff.eli}{
%%     ~~Describe \code{cutoff.eli} here~~
the cutoff to eliminate an overly toxic dose for safety. We recommend the default value of \code{(cutoff.eli=0.95)} for general use 
}
  \item{extrasafe}{
%%     ~~Describe \code{ntrial} here~~
set \code{extrasafe=TRUE} to impose a more stringent stopping rule
}
  \item{offset}{
%%     ~~Describe \code{ntrial} here~~
a small positive number (between 0 and 0.5) to control how strict the stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a more strict stopping rule. The default value \code{offset=0.05} generally works well.
}
  \item{ntrial}{
%%     ~~Describe \code{ntrial} here~~
the total number of trials to be simulated. 
}
}
\details{
The operating characteristics of the BOIN design are generated by simulating trials under the prespecified  true toxicity probabilities of the investigational doses. The BOIN design has two built-in stopping rules: (1) stop the trial if the lowest dose is eliminated due to toxicity, and no dose should be selected as the MTD; and (2) stop the trial and select the MTD if the number of patients treated at the current dose reaches \code{n.earlystop}. The first stopping rule is a safety rule to protect patients from the case in which all doses are overly toxic. The rationale for the second stopping rule is that when there is a large number (i.e., \code{n.earlystop}) of patients assigned to a dose, it means that the dose-finding algorithm has approximately converged. Thus, we can stop the trial early and select the MTD to save sample size and reduce the trial duration.  

For some applications, investigators may prefer a more strict safety stopping rule than rule (1) for extra safety when the lowest dose is overly toxic. This can be achieved by setting \code{extrasafe=TRUE}, which imposes the following more strict safety stopping rule: stop the trial if (i) the number of patients treated at the lowest dose >=3, and (ii) Pr(toxicity rate of the lowest dose > \code{target} | data) > \code{cutoff.eli-offset}. As a tradeoff, the strong stopping rule will decrease the MTD selection percentage when the lowest dose actually is the MTD.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
\code{get.oc.comb()} returns the operating characteristics of the BOIN design as a list, including (1) selection percentage at each dose level (selpercent), (2) the number of patients treated at each dose level (nptsdose), (3) the number of toxicities observed at each dose level (ntoxdose), (4) the total correct selection of the MTD (mtdpercent), (5) the total percentage of patients treated at the MTD (mtdpts). 
}

\references{
%% ~put references to the literature/web site here ~
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical Trials, \emph{Journal of the Royal Statistical Society: Series C}, 64, 507-523.

Lin R. and Yin, G. (2015). Bayesian Optimal Interval Designs for Dose Finding in Drug-combination Trials, \emph{Statistical Methods in Medical Research}, to appear.
}

\author{
Suyu Liu and Ying Yuan (yyuan@mdanderson.org)
}

\note{
%%  ~~further notes~~
%% We recommend using the local BOIN design (i.e., the default option) because of its better operating characteristics and simplicity. 
We should avoid setting the values of \code{p.saf} and \code{p.tox} very close to the \code{target}. This is because the small sample sizes of typical phase I trials prevent us from differentiating the target toxicity rate from the rates close to it. In addition, in most clinical applications, the target toxicity rate is often a rough guess, and finding a dose level with a toxicity rate reasonably close to the target rate will still be of interest to the investigator. The default values provided by \code{get.oc.comb()} are generally reasonable for most clinical applications.  
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.0_tutorial.pdf}

Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

\examples{
## Consider a 3x5 drug combination trial with 3 doses of agent A and 
## 5 doses of agent B. The goal is to find the MTD with a target toxicity
## rate of 0.3 with the maximum sample size of 40 patients in cohort size 
## of 1. A total of 1,000 trials are simulated. p.true is a 3x5 matrix 
## containing the true toxicity probablities of dose combinations

p.true = matrix(c(0.05,0.10,0.15,0.30,0.45,0.10,0.15,0.30,0.45,0.55,
0.15,0.30,0.45,0.50,0.60), ncol=5, byrow=TRUE)
get.oc.comb(target=0.3, p.true, ncohort=40, cohortsize=1, ntrial=1000)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ operating characteristics }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
