% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_number_of_clusters_stable_process.R
\name{expected_number_of_components_stable}
\alias{expected_number_of_components_stable}
\title{Computes the expected number of components for a stable process.}
\usage{
expected_number_of_components_stable(n, Gama, ntrunc = NULL)
}
\arguments{
\item{n}{Number of data points}

\item{Gama}{Numeric constant. 0 <= Gama <=1.}

\item{ntrunc}{Level of truncation when computing the expectation. Defaults
to n. If greater than n, it is fixed to n.}
}
\value{
A real value of type mpfr1 which approximates the expected number of
components

In spite of the high precision arithmetic packages used for in function, it
can be numerically unstable for small values of Gama. This is because
evaluating a sum with alternated signs, in the generalized factorial
coefficients, is tricky. Reference: P. De Blasi, S. Favaro, A. Lijoi, R. H.
Mena, I. Prünster, and M. Ruggiero, “Are gibbs-type priors the most natural
generalization of the Dirichlet process?,” IEEE Trans. Pattern Anal. Mach.
Intell., vol. 37, no. 2, pp. 212–229, 2015.
}
\description{
Computes the expected number of components for a stable process.
}
\examples{

expected_number_of_components_stable(100, 0.8)
}
