% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOFplots.R
\name{plotCDF_censored}
\alias{plotCDF_censored}
\title{Plot the Turnbull CDF and fitted CDF for censored data.}
\usage{
plotCDF_censored(fit)
}
\arguments{
\item{fit}{The result of the fit, obtained through the function MixNRMI1cens
or MixNRMI2cens.}
}
\value{
Plot of the empirical and fitted CDF for non censored data.
}
\description{
Plot the Turnbull CDF and fitted CDF for censored data.
}
\examples{

set.seed(150520)
data(salinity)
out <- MixNRMI1cens(salinity$left, salinity$right, extras = TRUE, Nit = 100)
BNPdensity:::plotCDF_censored(out)
}
