% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_clustering_analysis.R
\name{compute_optimal_clustering}
\alias{compute_optimal_clustering}
\title{Compute the optimal clustering from an MCMC sample}
\usage{
compute_optimal_clustering(fit, loss_type = "VI")
}
\arguments{
\item{fit}{The fitted object, obtained from one of the MixNRMIx functions}

\item{loss_type}{Defines the loss function to be used in the expected
posterior loss minimization. Can be one of "VI" (Variation of Information),
"B" (Binder's loss), "NVI" (Normalized Variation of Information) or "NID"
(Normalized Information Distance). Defaults to "VI".}
}
\value{
A vector of integers with the same size as the data, indicating the
allocation of each data point.
}
\description{
Summarizes the posterior on all possible clusterings by an optimal
clustering where optimality is defined as minimizing the posterior
expectation of a specific loss function, the Variation of Information or
Binder's loss function. Computation can be lengthy for large datasets,
because of the large size of the space of all clusterings.
}
