% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIS.R
\name{pivot_longer_bis}
\alias{pivot_longer_bis}
\title{Convert a BIS data set to long format}
\usage{
pivot_longer_bis(tbl)
}
\arguments{
\item{tbl}{Tibble. A tibble data frame containing a BIS data set (usually
obtained via \code{get_bis(url, auto_pivot = FALSE)}).}
}
\value{
A tibble data frame.
}
\description{
Convert a BIS data set to long format
}
\examples{
\donttest{
ds    <- get_datasets()
rates <- get_bis(ds$url[ds$id == "full_cbpol_m_csv"], auto_pivot = FALSE)
rates <- subset(rates, ref_area \%in\% c("US", "DE", "JP"))
rates <- pivot_longer_bis(rates)
}
}
