context("makeDataFrame")

test_that("makeDataFrame", {
  df1 = makeDataFrame(0, 0)
  df2 = data.frame()
  expect_equal(df1, df2)
  df1 = makeDataFrame(3, 0)
  df2 = data.frame(matrix(nrow = 3, ncol = 0))
  expect_equal(df1, df2)
  df1 = makeDataFrame(0, 2, "character")
  df2 = data.frame(setColNames(matrix("a", nrow = 0, ncol = 2), c("V1", "V2")), stringsAsFactors = FALSE)
  expect_equal(df1, df2)
  df1 = makeDataFrame(3, 1, "integer")
  df2 = data.frame(V1 = integer(3))
  expect_equal(df1, df2)
  df1 = makeDataFrame(3, 2, "integer")
  df2 = as.data.frame(matrix(0L, 3, 2))
  expect_equal(df1, df2)
  df1 = makeDataFrame(3, 2, init = "bb")
  df2 = as.data.frame(matrix("bb", 3, 2), stringsAsFactors = FALSE)
  expect_equal(df1, df2)
  df1 = makeDataFrame(3, 2, c("numeric", "integer"))
  df2 = data.frame(V1 = numeric(3), V2 = integer(3), stringsAsFactors = FALSE)
  expect_equal(df1, df2)

  # names
  df1 = makeDataFrame(1, 2, "integer", row.names = c("r1"), col.names = c("c1", "c2"))
  df2 = setRowNames(data.frame(c1 = 0, c2 = 0), "r1")
  expect_equal(df1, df2)
  df1 = makeDataFrame(1, 2, "integer", row.names = 1L, col.names = c("c1", "c2"))
  df2 = setRowNames(data.frame(c1 = 0, c2 = 0), 1L)
  expect_equal(df1, df2)
  df1 = makeDataFrame(1, 2, "integer", row.names = NULL, col.names = 1:2)
  df2 = setColNames(data.frame(c1 = 0, c2 = 0), 1:2)
  expect_equal(df1, df2)
})
