% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.STD.R
\name{Networks.STD}
\alias{Networks.STD}
\title{Standard Algorithm for Bayesian Network Discovery}
\usage{
Networks.STD(pvalue, net, iter = 5000, nburns = 2000, piall = c(0.75, 0.8,
  0.85, 0.9), rhoall = c(0.5, 1, 5, 10, 15), status = FALSE, fit,
  show.steps = 1, showlikelihood = FALSE, likelihood.frequency = 100)
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{net}{a n by n network configuration, n is the length of pvalue}

\item{iter}{number of iterations. The default is 5000}

\item{nburns}{number of burn-in. The default is 2000}

\item{piall}{a vector of selections of pi0. The default vector is 0.75, 0.8, 0.85, 0.9. The selections of pi0 should be placed in sequence, from smaller to larger.}

\item{rhoall}{a vector of selections of rho0 and rho1. The default vector is 0.5, 1, 5, 10, 15. The selections of rho0 and rho1 should be placed in sequence, from smaller to larger.}

\item{status}{default=FALSE}

\item{fit}{NULL}

\item{show.steps}{number default=1}

\item{showlikelihood}{logical default=FALSE}

\item{likelihood.frequency}{number default=100}
}
\value{
The trace of gi showing the evolution of the Monte Carlo Markov Chain
}
\description{
Standard Algorithm for Bayesian Network Discovery
}
\details{
This generic function fits a Bayesian Nonparametric Mixture Model for gene selection incorporating network information (Zhao et al., 2014):
\itemize{
\item  r_i| g_i, \strong{theta} ~ N(mu_{g_i}, sigma_{g_i}),
\item	g_i | z_i=k, \strong{q}_k ~ Discrete(\strong{a}_k, \strong{q}_k),
\item	\strong{theta} ~ G_{0k}, for g in \strong{a}_k,
\item	\strong{q}_k ~ Dirichlet(tau_k \strong{1}_{L_k}/L_k),
\item	\strong{theta}={\strong{theta}_g}_{g in \strong{a}_0 and \strong{a}_1} 
\item	\strong{theta}_g=(mu_g, sigma_g)
}
where we define 
\describe{
\item{Index}{\strong{a}_0=(-L_0+1,-L_0+2,...,0) , \strong{a}_1=(1,2,...,L_1) and the correspondent probability q_0=(q_{-L_0+1}, q_{-L_0+2}, ...,q_0), q_1=(q_1, q_2, ..., q_{L_1}), according to the defination of Discrete(\strong{a}_k, \strong{b}_k), for example, Pr(g_i={L_0+2})=q_{-L_0+2}. }
\item{Assumption}{We have an assumption that "selected" gene or image pixel should have larger statiscs comparing to "unselected" ones without the loss of generality. In this regard, we set the restriction mu_g<mu_{g+1} for g=-L_0+1, -L_0+2,...,L_1.}
}
For this function, The NET-DPM-1, considered as standard function is applied , and more details about the algorithm can be referred from Appnendix B.1 of Zhao et al., 2014
}
\examples{
#' ##Creating the network of 10X10 image
\dontrun{
library(igraph)
library(BayesNetDiscovery)
g <- graph.lattice(length=10,dim=2)
## the input of argument \\code{net}
net=as(get.adjacency(g,attr=NULL),"matrix")
##Assign the signal elements with signal intenstion as normal distribution N(1,0.2). 
While noise is set as N(0,0.2) 
newz=rep(0,100)
for (i in 3:7)
{
 newz[(i*10+3):(i*10+7)]=1
}
testcov<-0
for(i in 1:100){
 if(newz[i]==0){
   testcov[i]<-rnorm(1,mean=0,sd=0.2)
 
 }else{
  testcov[i]<-rnorm(1,mean=1,sd=0.2)
   
 }
}
##The profile of the impage
image(matrix(testcov,10,10),col=gray(seq(0,1,length=255)))
##Transform the signals into pvalue form and begin identification
pvalue=pnorm(-testcov)
total=Networks.STD(pvalue,net,iter=5000,piall=c(0.8, 0.85, 0.9, 0.95),
rhoall=c(0.5,1,5,10,15))
}
}
\references{
Zhao, Y.*, Kang, J., Yu, T. A Bayesian nonparametric mixture model for gene and gene-sub network selection
Annals of Applied Statistics, In press: 2014.
}
