% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{conversion_table_ordinal}
\alias{conversion_table_ordinal}
\title{AutoScore function: Print conversion table for ordinal outcomes to map score to risk}
\usage{
conversion_table_ordinal(
  pred_score,
  link = "logit",
  max_score = 100,
  score_breaks = seq(from = 5, to = 70, by = 5),
  ...
)
}
\arguments{
\item{pred_score}{A \code{data.frame} with outcomes and final scores
generated from \code{\link{AutoScore_fine_tuning_Ordinal}}}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{max_score}{Maximum attainable value of final scores.}

\item{score_breaks}{A vector of score breaks to group scores. The average
predicted risk will be reported for each score interval in the lookup
table. Users are advised to first visualise the predicted risk for all
attainable scores to determine \code{scores} (see
\code{\link{plot_predicted_risk}})}

\item{...}{Additional parameters to pass to \code{\link[knitr]{kable}}.}
}
\value{
No return value and the conversion will be printed out directly.
}
\description{
AutoScore function: Print conversion table for ordinal outcomes to map score to risk
}
\seealso{
\code{\link{AutoScore_testing_Ordinal}}
}
