% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.CorrMatrix}
\alias{Plot.CorrMatrix}
\title{Plot.CorrMatrix}
\usage{
Plot.CorrMatrix(
  dt = NULL,
  CorrVars = NULL,
  CorrVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  Method = "spearman",
  PreAgg = FALSE,
  MaxNAPercent = 0.05,
  Height = NULL,
  Width = NULL,
  Title = "Correlation Matrix",
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "macarons",
  MouseScroll = TRUE,
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  yaxis.fontSize = 14,
  xaxis.fontSize = 14,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{CorrVars}{vector of variable names}

\item{CorrVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{Method}{character}

\item{PreAgg}{logical}

\item{MaxNAPercent}{numeric}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{character}

\item{ShowLabels}{character}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", #' "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", #' "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", #' "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{TextColor}{character hex}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{yaxis.fontSize}{14}

\item{xaxis.fontSize}{14}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Build a correlation matrix plot by simply passing arguments to a single function. It will sample your data using SampleSize number of rows. Sampled data is randomized.
}
\examples{
# Create fake data
data <- AutoPlots::FakeDataGenerator(N = 100000)

# Echarts CorrMatrix Plot Chart
AutoPlots::Plot.CorrMatrix(
  dt = data,
  CorrVars = c(
    "Adrian",
    "Independent_Variable1",
    "Independent_Variable2",
    "Independent_Variable3",
    "Independent_Variable4",
    "Independent_Variable5"),
  CorrVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  Method = 'pearson',
  PreAgg = FALSE,
  MaxNAPercent = 0.05,
  Height = NULL,
  Width = NULL,
  Title = "Correlation Matrix",
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "macarons",
  MouseScroll = TRUE,
  TextColor = "black",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = '#63aeff',
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  yaxis.fontSize = 14,
  xaxis.fontSize = 14,
  Debug = FALSE)

}
\seealso{
Other Standard Plots: 
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
