% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon.signedrank.R
\name{wilcoxon.signedrank}
\alias{wilcoxon.signedrank}
\title{Perform Wilcoxon signed-rank test}
\usage{
wilcoxon.signedrank(
  x,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  cont.corr = TRUE,
  CI.width = 0.95,
  max.exact.cases = 1000,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{wilcoxon.signedrank()} performs the Wilcoxon signed-rank test and is used in chapters 3, 4 and 5 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 3.4 from "Applied Nonparametric Statistical Methods" (5th edition)
wilcoxon.signedrank(ch3$heartrates1, 70, "greater")

# Exercise 5.12 from "Applied Nonparametric Statistical Methods" (5th edition)
wilcoxon.signedrank(ch5$kHz0.125 - ch5$kHz0.25, 0)

}
