% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHPtools.R
\name{consEval}
\alias{consEval}
\title{Find consistency of a PCM based on Preference Reversals}
\usage{
consEval(pcm)
}
\arguments{
\item{pcm}{A pairwise comparison matrix}
}
\value{
A list of four elements,
logitConsistency = the probability that the PCM is consistent,
prop3Rev = the proportion of triad-based preference reversals for the PCM,
max3Rev = the maximum triad-based preference reversal for the PCM,
triadsData = a data frame with 8 columns, providing the full data of preference reversals
       (1) triadE1 alternative 1  in the triad; e.g. a4 for the fourth alternative
       (2) triadE2 alternative 2 in the triad
       (3) triadE3 alternative 3 in the triad
       (4) pref3Rev measure of the intensity of preference reversal for the particular triad
       (5) pcmWeightE1 eigen weight of alternative triadE1 from the entire eigenvector
       (6) pcmWeightE2 eigen weight of alternative triadE2 from the entire eigenvector
       (7) triadWeightE1 eigen weight of alternative triadE1 from the order-3 sub matrix
       (8) triadWeightE2 eigen weight of alternative triadE2 from the order-3 sub matrix
}
\description{
This function finds all triad based preference reversals for a PCM.
#' Triads are subsets of 3 elements chosen from the 'n' alternatives of an order-n
PCM. A triad reversal is said to occur if any two elements of the order-3 PCM
show a reversal in preference with the corresponding elements of the full eigenvector.

This returns a list of values related to triad Preference Reversal consistency.
The fourth item of the list is a data frame of triads where reversals are seen,
with the logit Consistency probability measure based on them, the proportion of
reversals, the maximum reversal and the data frame with the details.
}
\examples{
pcm1 <- matrix(c(1,1,2,1,2,2, 1,1,1,1/3,1,1, 1/2,1,1,1,1,1, 1,3,1,1,2,1,
                 1/2,1,1,1/2,1,1/4, 1/2,1,1,1,4,1), nrow=6, byrow=TRUE)
cons1 <- consEval(pcm1)
cons1
pcm2 <- matrix(c(1,1/6,1/5,1/2,1/6,1/3,1/3,1/8,  6,1,1,3,1,1,2,1,
                 5,1,1,3,1/3,1,2,1/2, 2,1/3,1/3,1,1/5,1/2,1/2,1/4,  
                 6,1,3,5,1,1,2,1,  3,1,1,2,1,1,1,1/3,
                 3,1/2,1/2,2,1/2,1,1,1/4,  8,1,2,4,1,3,4,1), 
                 nrow=8, byrow=TRUE)
cons2 <- consEval(pcm2)
cons2
pcm3 <- createLogicalPCM(7) 
cons3 <- consEval(pcm3)
print(paste(formatC(cons3$logitConsistency,format="e",digits=4), 
         formatC(cons3$prop3Rev,format="f",digits=4), 
         formatC(cons3$max3Rev,format="f", digits=4)))
}
