% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcvExports.R
\name{totalPenaltySpace}
\alias{totalPenaltySpace}
\title{Obtaining (orthogonal) basis for null space and range of the penalty matrix}
\usage{
totalPenaltySpace(S, H, off, p)
}
\arguments{
\item{S}{a list of penalty matrices, in packed form.}

\item{H}{the coefficient matrix of an user supplied fixed quadratic 
penalty on the parameters of the GAM.}

\item{off}{a vector where the i-th element is the offset for the i-th matrix.}

\item{p}{total number of parameters.}
}
\value{
A list of matrix square roots such that \code{S[[i]]=B[[i]]\%*\%t(B[[i]])}.
}
\description{
INTERNAL function to obtain (orthogonal) basis for the null space and
             range space of the penalty, and obtain actual null space dimension
             components are roughly rescaled to avoid any dominating.
}
\author{
Simon N. Wood <simon.wood@r-project.org>.
}
