//------------------------------------------------------------------------------
// CHOLMOD/Partition/cholmod_metis_wrapper.h: METIS renaming for CHOLMOD
//------------------------------------------------------------------------------

// CHOLMOD/Partition Module.  Copyright (C) 2005-2023, University of Florida.
// All Rights Reserved.  Author: Timothy A. Davis.
// SPDX-License-Identifier: LGPL-2.1+

//------------------------------------------------------------------------------

#ifndef CHOLMOD_METIS_WRAP_H
#define CHOLMOD_METIS_WRAP_H

// always use GKRAND instead of the system rand in METIS
#ifndef USE_GKRAND
#define USE_GKRAND
#endif

#if SUITESPARSE_COMPILER_MSC
    #undef  __thread
    #define __thread __declspec(thread)
#endif

#define CoarsenGraphNlevels                       SuiteSparse_metis_CoarsenGraphNlevels
#define ComputeAccuracy                           SuiteSparse_metis_ComputeAccuracy
#define ComputeBFSOrdering                        SuiteSparse_metis_ComputeBFSOrdering
#define ComputeMean                               SuiteSparse_metis_ComputeMean
#define ComputeMedianRFP                          SuiteSparse_metis_ComputeMedianRFP
#define ComputeROCn                               SuiteSparse_metis_ComputeROCn
#define ComputeStdDev                             SuiteSparse_metis_ComputeStdDev

#define decodeblock                               SuiteSparse_metis_decodeblock
#define encodeblock                               SuiteSparse_metis_encodeblock
#define errexit                                   SuiteSparse_metis_errexit

#define gk_CPUSeconds                             SuiteSparse_metis_gk_CPUSeconds
#define gk_WClockSeconds                          SuiteSparse_metis_gk_WClockSeconds

#define gk_cur_jbufs                              SuiteSparse_metis_gk_cur_jbufs
#define gk_jbuf                                   SuiteSparse_metis_gk_jbuf
#define gk_jbufs                                  SuiteSparse_metis_gk_jbufs

#define gk_AllocMatrix                            SuiteSparse_metis_gk_AllocMatrix
#define gk_array2csr                              SuiteSparse_metis_gk_array2csr

#define gk_cargmax                                SuiteSparse_metis_gk_cargmax
#define gk_cargmin                                SuiteSparse_metis_gk_cargmin
#define gk_cincset                                SuiteSparse_metis_gk_cincset
#define gk_cmax                                   SuiteSparse_metis_gk_cmax
#define gk_cmin                                   SuiteSparse_metis_gk_cmin
#define gk_cnorm2                                 SuiteSparse_metis_gk_cnorm2
#define gk_csum                                   SuiteSparse_metis_gk_csum
#define gk_cAllocMatrix                           SuiteSparse_metis_gk_cAllocMatrix
#define gk_cargmax_n                              SuiteSparse_metis_gk_cargmax_n
#define gk_caxpy                                  SuiteSparse_metis_gk_caxpy
#define gk_ccopy                                  SuiteSparse_metis_gk_ccopy
#define gk_cdot                                   SuiteSparse_metis_gk_cdot
#define gk_cFreeMatrix                            SuiteSparse_metis_gk_cFreeMatrix
#define gk_ckvAllocMatrix                         SuiteSparse_metis_gk_ckvAllocMatrix
#define gk_ckvcopy                                SuiteSparse_metis_gk_ckvcopy
#define gk_ckvFreeMatrix                          SuiteSparse_metis_gk_ckvFreeMatrix
#define gk_ckvmalloc                              SuiteSparse_metis_gk_ckvmalloc
#define gk_ckvrealloc                             SuiteSparse_metis_gk_ckvrealloc
#define gk_ckvset                                 SuiteSparse_metis_gk_ckvset
#define gk_ckvSetMatrix                           SuiteSparse_metis_gk_ckvSetMatrix
#define gk_ckvsmalloc                             SuiteSparse_metis_gk_ckvsmalloc
#define gk_ckvsortd                               SuiteSparse_metis_gk_ckvsortd
#define gk_ckvsorti                               SuiteSparse_metis_gk_ckvsorti
#define gk_cmalloc                                SuiteSparse_metis_gk_cmalloc
#define gk_crand                                  SuiteSparse_metis_gk_crand
#define gk_crandArrayPermute                      SuiteSparse_metis_gk_crandArrayPermute
#define gk_crandArrayPermuteFine                  SuiteSparse_metis_gk_crandArrayPermuteFine
#define gk_crandInRange                           SuiteSparse_metis_gk_crandInRange
#define gk_crealloc                               SuiteSparse_metis_gk_crealloc
#define gk_cscale                                 SuiteSparse_metis_gk_cscale
#define gk_cset                                   SuiteSparse_metis_gk_cset
#define gk_cSetMatrix                             SuiteSparse_metis_gk_cSetMatrix
#define gk_csmalloc                               SuiteSparse_metis_gk_csmalloc
#define gk_csortd                                 SuiteSparse_metis_gk_csortd
#define gk_csorti                                 SuiteSparse_metis_gk_csorti
#define gk_csrand                                 SuiteSparse_metis_gk_csrand

#define gk_csr_CompactColumns                     SuiteSparse_metis_gk_csr_CompactColumns
#define gk_csr_ComputeSimilarity                  SuiteSparse_metis_gk_csr_ComputeSimilarity
#define gk_csr_ComputeSquaredNorms                SuiteSparse_metis_gk_csr_ComputeSquaredNorms
#define gk_csr_ComputeSums                        SuiteSparse_metis_gk_csr_ComputeSums
#define gk_csr_Create                             SuiteSparse_metis_gk_csr_Create
#define gk_csr_CreateIndex                        SuiteSparse_metis_gk_csr_CreateIndex
#define gk_csr_Dup                                SuiteSparse_metis_gk_csr_Dup
#define gk_csr_ExtractPartition                   SuiteSparse_metis_gk_csr_ExtractPartition
#define gk_csr_ExtractRows                        SuiteSparse_metis_gk_csr_ExtractRows
#define gk_csr_ExtractSubmatrix                   SuiteSparse_metis_gk_csr_ExtractSubmatrix
#define gk_csr_Free                               SuiteSparse_metis_gk_csr_Free
#define gk_csr_FreeContents                       SuiteSparse_metis_gk_csr_FreeContents
#define gk_csr_GetSimilarRows                     SuiteSparse_metis_gk_csr_GetSimilarRows
#define gk_csr_Init                               SuiteSparse_metis_gk_csr_Init
#define gk_csr_LowFilter                          SuiteSparse_metis_gk_csr_LowFilter
#define gk_csr_Normalize                          SuiteSparse_metis_gk_csr_Normalize
#define gk_csr_Prune                              SuiteSparse_metis_gk_csr_Prune
#define gk_csr_Scale                              SuiteSparse_metis_gk_csr_Scale
#define gk_csr_SortIndices                        SuiteSparse_metis_gk_csr_SortIndices
#define gk_csr_Split                              SuiteSparse_metis_gk_csr_Split
#define gk_csr_TopKPlusFilter                     SuiteSparse_metis_gk_csr_TopKPlusFilter
#define gk_csr_ZScoreFilter                       SuiteSparse_metis_gk_csr_ZScoreFilter

#define GKDecodeBase64                            SuiteSparse_metis_GKDecodeBase64
#define GKEncodeBase64                            SuiteSparse_metis_GKEncodeBase64

#define gk_dfkvkselect                            SuiteSparse_metis_gk_dfkvkselect
#define gk_dAllocMatrix                           SuiteSparse_metis_gk_dAllocMatrix
#define gk_dargmax_n                              SuiteSparse_metis_gk_dargmax_n
#define gk_daxpy                                  SuiteSparse_metis_gk_daxpy
#define gk_dcopy                                  SuiteSparse_metis_gk_dcopy
#define gk_ddot                                   SuiteSparse_metis_gk_ddot
#define gk_dFreeMatrix                            SuiteSparse_metis_gk_dFreeMatrix
#define gk_dkvAllocMatrix                         SuiteSparse_metis_gk_dkvAllocMatrix
#define gk_dkvcopy                                SuiteSparse_metis_gk_dkvcopy
#define gk_dkvFreeMatrix                          SuiteSparse_metis_gk_dkvFreeMatrix
#define gk_dkvmalloc                              SuiteSparse_metis_gk_dkvmalloc
#define gk_dkvrealloc                             SuiteSparse_metis_gk_dkvrealloc
#define gk_dkvset                                 SuiteSparse_metis_gk_dkvset
#define gk_dkvSetMatrix                           SuiteSparse_metis_gk_dkvSetMatrix
#define gk_dkvsmalloc                             SuiteSparse_metis_gk_dkvsmalloc
#define gk_dkvsortd                               SuiteSparse_metis_gk_dkvsortd
#define gk_dkvsorti                               SuiteSparse_metis_gk_dkvsorti
#define gk_dmalloc                                SuiteSparse_metis_gk_dmalloc
#define gk_dpqCheckHeap                           SuiteSparse_metis_gk_dpqCheckHeap
#define gk_dpqCreate                              SuiteSparse_metis_gk_dpqCreate
#define gk_dpqDelete                              SuiteSparse_metis_gk_dpqDelete
#define gk_dpqDestroy                             SuiteSparse_metis_gk_dpqDestroy
#define gk_dpqFree                                SuiteSparse_metis_gk_dpqFree
#define gk_dpqGetTop                              SuiteSparse_metis_gk_dpqGetTop
#define gk_dpqInit                                SuiteSparse_metis_gk_dpqInit
#define gk_dpqInsert                              SuiteSparse_metis_gk_dpqInsert
#define gk_dpqLength                              SuiteSparse_metis_gk_dpqLength
#define gk_dpqReset                               SuiteSparse_metis_gk_dpqReset
#define gk_dpqSeeKey                              SuiteSparse_metis_gk_dpqSeeKey
#define gk_dpqSeeTopKey                           SuiteSparse_metis_gk_dpqSeeTopKey
#define gk_dpqSeeTopVal                           SuiteSparse_metis_gk_dpqSeeTopVal
#define gk_dpqUpdate                              SuiteSparse_metis_gk_dpqUpdate
#define gk_drand                                  SuiteSparse_metis_gk_drand
#define gk_drandArrayPermute                      SuiteSparse_metis_gk_drandArrayPermute
#define gk_drandArrayPermuteFine                  SuiteSparse_metis_gk_drandArrayPermuteFine
#define gk_drandInRange                           SuiteSparse_metis_gk_drandInRange
#define gk_drealloc                               SuiteSparse_metis_gk_drealloc
#define gk_dscale                                 SuiteSparse_metis_gk_dscale
#define gk_dset                                   SuiteSparse_metis_gk_dset
#define gk_dSetMatrix                             SuiteSparse_metis_gk_dSetMatrix
#define gk_dsmalloc                               SuiteSparse_metis_gk_dsmalloc
#define gk_dsortd                                 SuiteSparse_metis_gk_dsortd
#define gk_dsorti                                 SuiteSparse_metis_gk_dsorti
#define gk_dsrand                                 SuiteSparse_metis_gk_dsrand
#define gk_dargmax                                SuiteSparse_metis_gk_dargmax
#define gk_dargmin                                SuiteSparse_metis_gk_dargmin
#define gk_dincset                                SuiteSparse_metis_gk_dincset
#define gk_dmax                                   SuiteSparse_metis_gk_dmax
#define gk_dmin                                   SuiteSparse_metis_gk_dmin
#define gk_dnorm2                                 SuiteSparse_metis_gk_dnorm2
#define gk_dsum                                   SuiteSparse_metis_gk_dsum

#define gk_errexit                                SuiteSparse_metis_gk_errexit
#define gkfooo                                    SuiteSparse_metis_gkfooo
#define gk_FreeMatrix                             SuiteSparse_metis_gk_FreeMatrix

#define gk_fAllocMatrix                           SuiteSparse_metis_gk_fAllocMatrix
#define gk_fargmax_n                              SuiteSparse_metis_gk_fargmax_n
#define gk_faxpy                                  SuiteSparse_metis_gk_faxpy
#define gk_fcopy                                  SuiteSparse_metis_gk_fcopy
#define gk_fdot                                   SuiteSparse_metis_gk_fdot
#define gk_fFreeMatrix                            SuiteSparse_metis_gk_fFreeMatrix
#define gk_find_frequent_itemsets                 SuiteSparse_metis_gk_find_frequent_itemsets
#define gk_fkvAllocMatrix                         SuiteSparse_metis_gk_fkvAllocMatrix
#define gk_fkvcopy                                SuiteSparse_metis_gk_fkvcopy
#define gk_fkvFreeMatrix                          SuiteSparse_metis_gk_fkvFreeMatrix
#define gk_fkvmalloc                              SuiteSparse_metis_gk_fkvmalloc
#define gk_fkvrealloc                             SuiteSparse_metis_gk_fkvrealloc
#define gk_fkvset                                 SuiteSparse_metis_gk_fkvset
#define gk_fkvSetMatrix                           SuiteSparse_metis_gk_fkvSetMatrix
#define gk_fkvsmalloc                             SuiteSparse_metis_gk_fkvsmalloc
#define gk_fkvsortd                               SuiteSparse_metis_gk_fkvsortd
#define gk_fkvsorti                               SuiteSparse_metis_gk_fkvsorti
#define gk_flog2                                  SuiteSparse_metis_gk_flog2
#define gk_fmalloc                                SuiteSparse_metis_gk_fmalloc
#define gk_fpqCheckHeap                           SuiteSparse_metis_gk_fpqCheckHeap
#define gk_fpqCreate                              SuiteSparse_metis_gk_fpqCreate
#define gk_fpqDelete                              SuiteSparse_metis_gk_fpqDelete
#define gk_fpqDestroy                             SuiteSparse_metis_gk_fpqDestroy
#define gk_fpqFree                                SuiteSparse_metis_gk_fpqFree
#define gk_fpqGetTop                              SuiteSparse_metis_gk_fpqGetTop
#define gk_fpqInit                                SuiteSparse_metis_gk_fpqInit
#define gk_fpqInsert                              SuiteSparse_metis_gk_fpqInsert
#define gk_fpqLength                              SuiteSparse_metis_gk_fpqLength
#define gk_fpqReset                               SuiteSparse_metis_gk_fpqReset
#define gk_fpqSeeKey                              SuiteSparse_metis_gk_fpqSeeKey
#define gk_fpqSeeTopKey                           SuiteSparse_metis_gk_fpqSeeTopKey
#define gk_fpqSeeTopVal                           SuiteSparse_metis_gk_fpqSeeTopVal
#define gk_fpqUpdate                              SuiteSparse_metis_gk_fpqUpdate
#define gk_frand                                  SuiteSparse_metis_gk_frand
#define gk_frandArrayPermute                      SuiteSparse_metis_gk_frandArrayPermute
#define gk_frandArrayPermuteFine                  SuiteSparse_metis_gk_frandArrayPermuteFine
#define gk_frandInRange                           SuiteSparse_metis_gk_frandInRange
#define gk_frealloc                               SuiteSparse_metis_gk_frealloc
#define gk_free                                   SuiteSparse_metis_gk_free
#define gk_fscale                                 SuiteSparse_metis_gk_fscale
#define gk_fset                                   SuiteSparse_metis_gk_fset
#define gk_fSetMatrix                             SuiteSparse_metis_gk_fSetMatrix
#define gk_fsmalloc                               SuiteSparse_metis_gk_fsmalloc
#define gk_fsortd                                 SuiteSparse_metis_gk_fsortd
#define gk_fsorti                                 SuiteSparse_metis_gk_fsorti
#define gk_fsrand                                 SuiteSparse_metis_gk_fsrand
#define gk_fargmax                                SuiteSparse_metis_gk_fargmax
#define gk_fargmin                                SuiteSparse_metis_gk_fargmin
#define gk_fincset                                SuiteSparse_metis_gk_fincset
#define gk_fmax                                   SuiteSparse_metis_gk_fmax
#define gk_fmin                                   SuiteSparse_metis_gk_fmin
#define gk_fnorm2                                 SuiteSparse_metis_gk_fnorm2
#define gk_fsum                                   SuiteSparse_metis_gk_fsum


#define gk_GetCurMemoryUsed                       SuiteSparse_metis_gk_GetCurMemoryUsed
#define gk_GetMaxMemoryUsed                       SuiteSparse_metis_gk_GetMaxMemoryUsed
#define gk_getopt                                 SuiteSparse_metis_gk_getopt
#define gk_getopt_long                            SuiteSparse_metis_gk_getopt_long
#define gk_getopt_long_only                       SuiteSparse_metis_gk_getopt_long_only
#define gk_gkmcoreAdd                             SuiteSparse_metis_gk_gkmcoreAdd
#define gk_gkmcoreCreate                          SuiteSparse_metis_gk_gkmcoreCreate
#define gk_gkmcoreDel                             SuiteSparse_metis_gk_gkmcoreDel
#define gk_gkmcoreDestroy                         SuiteSparse_metis_gk_gkmcoreDestroy
#define gk_gkmcorePop                             SuiteSparse_metis_gk_gkmcorePop
#define gk_gkmcorePush                            SuiteSparse_metis_gk_gkmcorePush
#define gk_graph_ComputeBestFOrdering             SuiteSparse_metis_gk_graph_ComputeBestFOrdering
#define gk_graph_ComputeBestFOrdering0            SuiteSparse_metis_gk_graph_ComputeBestFOrdering0
#define gk_graph_ComputeBFSOrdering               SuiteSparse_metis_gk_graph_ComputeBFSOrdering
#define gk_graph_Create                           SuiteSparse_metis_gk_graph_Create
#define gk_graph_Dup                              SuiteSparse_metis_gk_graph_Dup
#define gk_graph_ExtractSubgraph                  SuiteSparse_metis_gk_graph_ExtractSubgraph
#define gk_graph_FindComponents                   SuiteSparse_metis_gk_graph_FindComponents
#define gk_graph_Free                             SuiteSparse_metis_gk_graph_Free
#define gk_graph_FreeContents                     SuiteSparse_metis_gk_graph_FreeContents
#define gk_graph_Init                             SuiteSparse_metis_gk_graph_Init
#define gk_graph_Reorder                          SuiteSparse_metis_gk_graph_Reorder
#define gk_graph_SingleSourceShortestPaths        SuiteSparse_metis_gk_graph_SingleSourceShortestPaths

#define gk_i32AllocMatrix                         SuiteSparse_metis_gk_i32AllocMatrix
#define gk_i32argmax_n                            SuiteSparse_metis_gk_i32argmax_n
#define gk_i32axpy                                SuiteSparse_metis_gk_i32axpy
#define gk_i32copy                                SuiteSparse_metis_gk_i32copy
#define gk_i32dot                                 SuiteSparse_metis_gk_i32dot
#define gk_i32FreeMatrix                          SuiteSparse_metis_gk_i32FreeMatrix
#define gk_i32kvAllocMatrix                       SuiteSparse_metis_gk_i32kvAllocMatrix
#define gk_i32kvcopy                              SuiteSparse_metis_gk_i32kvcopy
#define gk_i32kvFreeMatrix                        SuiteSparse_metis_gk_i32kvFreeMatrix
#define gk_i32kvmalloc                            SuiteSparse_metis_gk_i32kvmalloc
#define gk_i32kvrealloc                           SuiteSparse_metis_gk_i32kvrealloc
#define gk_i32kvset                               SuiteSparse_metis_gk_i32kvset
#define gk_i32kvSetMatrix                         SuiteSparse_metis_gk_i32kvSetMatrix
#define gk_i32kvsmalloc                           SuiteSparse_metis_gk_i32kvsmalloc
#define gk_i32kvsortd                             SuiteSparse_metis_gk_i32kvsortd
#define gk_i32kvsorti                             SuiteSparse_metis_gk_i32kvsorti
#define gk_i32malloc                              SuiteSparse_metis_gk_i32malloc
#define gk_i32pqCheckHeap                         SuiteSparse_metis_gk_i32pqCheckHeap
#define gk_i32pqCreate                            SuiteSparse_metis_gk_i32pqCreate
#define gk_i32pqDelete                            SuiteSparse_metis_gk_i32pqDelete
#define gk_i32pqDestroy                           SuiteSparse_metis_gk_i32pqDestroy
#define gk_i32pqFree                              SuiteSparse_metis_gk_i32pqFree
#define gk_i32pqGetTop                            SuiteSparse_metis_gk_i32pqGetTop
#define gk_i32pqInit                              SuiteSparse_metis_gk_i32pqInit
#define gk_i32pqInsert                            SuiteSparse_metis_gk_i32pqInsert
#define gk_i32pqLength                            SuiteSparse_metis_gk_i32pqLength
#define gk_i32pqReset                             SuiteSparse_metis_gk_i32pqReset
#define gk_i32pqSeeKey                            SuiteSparse_metis_gk_i32pqSeeKey
#define gk_i32pqSeeTopKey                         SuiteSparse_metis_gk_i32pqSeeTopKey
#define gk_i32pqSeeTopVal                         SuiteSparse_metis_gk_i32pqSeeTopVal
#define gk_i32pqUpdate                            SuiteSparse_metis_gk_i32pqUpdate
#define gk_i32realloc                             SuiteSparse_metis_gk_i32realloc
#define gk_i32scale                               SuiteSparse_metis_gk_i32scale
#define gk_i32set                                 SuiteSparse_metis_gk_i32set
#define gk_i32SetMatrix                           SuiteSparse_metis_gk_i32SetMatrix
#define gk_i32smalloc                             SuiteSparse_metis_gk_i32smalloc
#define gk_i32argmax                              SuiteSparse_metis_gk_i32argmax
#define gk_i32argmin                              SuiteSparse_metis_gk_i32argmin
#define gk_i32incset                              SuiteSparse_metis_gk_i32incset
#define gk_i32max                                 SuiteSparse_metis_gk_i32max
#define gk_i32min                                 SuiteSparse_metis_gk_i32min
#define gk_i32norm2                               SuiteSparse_metis_gk_i32norm2
#define gk_i32sum                                 SuiteSparse_metis_gk_i32sum

#define gk_i64AllocMatrix                         SuiteSparse_metis_gk_i64AllocMatrix
#define gk_i64argmax_n                            SuiteSparse_metis_gk_i64argmax_n
#define gk_i64axpy                                SuiteSparse_metis_gk_i64axpy
#define gk_i64copy                                SuiteSparse_metis_gk_i64copy
#define gk_i64dot                                 SuiteSparse_metis_gk_i64dot
#define gk_i64FreeMatrix                          SuiteSparse_metis_gk_i64FreeMatrix
#define gk_i64kvAllocMatrix                       SuiteSparse_metis_gk_i64kvAllocMatrix
#define gk_i64kvcopy                              SuiteSparse_metis_gk_i64kvcopy
#define gk_i64kvFreeMatrix                        SuiteSparse_metis_gk_i64kvFreeMatrix
#define gk_i64kvmalloc                            SuiteSparse_metis_gk_i64kvmalloc
#define gk_i64kvrealloc                           SuiteSparse_metis_gk_i64kvrealloc
#define gk_i64kvset                               SuiteSparse_metis_gk_i64kvset
#define gk_i64kvSetMatrix                         SuiteSparse_metis_gk_i64kvSetMatrix
#define gk_i64kvsmalloc                           SuiteSparse_metis_gk_i64kvsmalloc
#define gk_i64kvsortd                             SuiteSparse_metis_gk_i64kvsortd
#define gk_i64kvsorti                             SuiteSparse_metis_gk_i64kvsorti
#define gk_i64malloc                              SuiteSparse_metis_gk_i64malloc
#define gk_i64pqCheckHeap                         SuiteSparse_metis_gk_i64pqCheckHeap
#define gk_i64pqCreate                            SuiteSparse_metis_gk_i64pqCreate
#define gk_i64pqDelete                            SuiteSparse_metis_gk_i64pqDelete
#define gk_i64pqDestroy                           SuiteSparse_metis_gk_i64pqDestroy
#define gk_i64pqFree                              SuiteSparse_metis_gk_i64pqFree
#define gk_i64pqGetTop                            SuiteSparse_metis_gk_i64pqGetTop
#define gk_i64pqInit                              SuiteSparse_metis_gk_i64pqInit
#define gk_i64pqInsert                            SuiteSparse_metis_gk_i64pqInsert
#define gk_i64pqLength                            SuiteSparse_metis_gk_i64pqLength
#define gk_i64pqReset                             SuiteSparse_metis_gk_i64pqReset
#define gk_i64pqSeeKey                            SuiteSparse_metis_gk_i64pqSeeKey
#define gk_i64pqSeeTopKey                         SuiteSparse_metis_gk_i64pqSeeTopKey
#define gk_i64pqSeeTopVal                         SuiteSparse_metis_gk_i64pqSeeTopVal
#define gk_i64pqUpdate                            SuiteSparse_metis_gk_i64pqUpdate
#define gk_i64realloc                             SuiteSparse_metis_gk_i64realloc
#define gk_i64scale                               SuiteSparse_metis_gk_i64scale
#define gk_i64set                                 SuiteSparse_metis_gk_i64set
#define gk_i64SetMatrix                           SuiteSparse_metis_gk_i64SetMatrix
#define gk_i64smalloc                             SuiteSparse_metis_gk_i64smalloc
#define gk_i64argmax                              SuiteSparse_metis_gk_i64argmax
#define gk_i64argmin                              SuiteSparse_metis_gk_i64argmin
#define gk_i64incset                              SuiteSparse_metis_gk_i64incset
#define gk_i64max                                 SuiteSparse_metis_gk_i64max
#define gk_i64min                                 SuiteSparse_metis_gk_i64min
#define gk_i64norm2                               SuiteSparse_metis_gk_i64norm2
#define gk_i64sum                                 SuiteSparse_metis_gk_i64sum

#define gk_idxAllocMatrix                         SuiteSparse_metis_gk_idxAllocMatrix
#define gk_idxargmax_n                            SuiteSparse_metis_gk_idxargmax_n
#define gk_idxaxpy                                SuiteSparse_metis_gk_idxaxpy
#define gk_idxcopy                                SuiteSparse_metis_gk_idxcopy
#define gk_idxdot                                 SuiteSparse_metis_gk_idxdot
#define gk_idxargmax                              SuiteSparse_metis_gk_idxargmax
#define gk_idxargmin                              SuiteSparse_metis_gk_idxargmin
#define gk_idxincset                              SuiteSparse_metis_gk_idxincset
#define gk_idxmax                                 SuiteSparse_metis_gk_idxmax
#define gk_idxmin                                 SuiteSparse_metis_gk_idxmin
#define gk_idxnorm2                               SuiteSparse_metis_gk_idxnorm2
#define gk_idxsum                                 SuiteSparse_metis_gk_idxsum
#define gk_idxFreeMatrix                          SuiteSparse_metis_gk_idxFreeMatrix
#define gk_idxkvAllocMatrix                       SuiteSparse_metis_gk_idxkvAllocMatrix
#define gk_idxkvcopy                              SuiteSparse_metis_gk_idxkvcopy
#define gk_idxkvFreeMatrix                        SuiteSparse_metis_gk_idxkvFreeMatrix
#define gk_idxkvmalloc                            SuiteSparse_metis_gk_idxkvmalloc
#define gk_idxkvrealloc                           SuiteSparse_metis_gk_idxkvrealloc
#define gk_idxkvset                               SuiteSparse_metis_gk_idxkvset
#define gk_idxkvSetMatrix                         SuiteSparse_metis_gk_idxkvSetMatrix
#define gk_idxkvsmalloc                           SuiteSparse_metis_gk_idxkvsmalloc
#define gk_idxkvsortd                             SuiteSparse_metis_gk_idxkvsortd
#define gk_idxkvsorti                             SuiteSparse_metis_gk_idxkvsorti
#define gk_idxmalloc                              SuiteSparse_metis_gk_idxmalloc
#define gk_idxpqCheckHeap                         SuiteSparse_metis_gk_idxpqCheckHeap
#define gk_idxpqCreate                            SuiteSparse_metis_gk_idxpqCreate
#define gk_idxpqDelete                            SuiteSparse_metis_gk_idxpqDelete
#define gk_idxpqDestroy                           SuiteSparse_metis_gk_idxpqDestroy
#define gk_idxpqFree                              SuiteSparse_metis_gk_idxpqFree
#define gk_idxpqGetTop                            SuiteSparse_metis_gk_idxpqGetTop
#define gk_idxpqInit                              SuiteSparse_metis_gk_idxpqInit
#define gk_idxpqInsert                            SuiteSparse_metis_gk_idxpqInsert
#define gk_idxpqLength                            SuiteSparse_metis_gk_idxpqLength
#define gk_idxpqReset                             SuiteSparse_metis_gk_idxpqReset
#define gk_idxpqSeeKey                            SuiteSparse_metis_gk_idxpqSeeKey
#define gk_idxpqSeeTopKey                         SuiteSparse_metis_gk_idxpqSeeTopKey
#define gk_idxpqSeeTopVal                         SuiteSparse_metis_gk_idxpqSeeTopVal
#define gk_idxpqUpdate                            SuiteSparse_metis_gk_idxpqUpdate
#define gk_idxrand                                SuiteSparse_metis_gk_idxrand
#define gk_idxrandArrayPermute                    SuiteSparse_metis_gk_idxrandArrayPermute
#define gk_idxrandArrayPermuteFine                SuiteSparse_metis_gk_idxrandArrayPermuteFine
#define gk_idxrandInRange                         SuiteSparse_metis_gk_idxrandInRange
#define gk_idxrealloc                             SuiteSparse_metis_gk_idxrealloc
#define gk_idxscale                               SuiteSparse_metis_gk_idxscale
#define gk_idxset                                 SuiteSparse_metis_gk_idxset
#define gk_idxSetMatrix                           SuiteSparse_metis_gk_idxSetMatrix
#define gk_idxsmalloc                             SuiteSparse_metis_gk_idxsmalloc
#define gk_idxsortd                               SuiteSparse_metis_gk_idxsortd
#define gk_idxsorti                               SuiteSparse_metis_gk_idxsorti
#define gk_idxsrand                               SuiteSparse_metis_gk_idxsrand

#define gk_iAllocMatrix                           SuiteSparse_metis_gk_iAllocMatrix
#define gk_iargmax_n                              SuiteSparse_metis_gk_iargmax_n
#define gk_iaxpy                                  SuiteSparse_metis_gk_iaxpy
#define gk_icopy                                  SuiteSparse_metis_gk_icopy
#define gk_idot                                   SuiteSparse_metis_gk_idot
#define gk_i2cc2i_create_common                   SuiteSparse_metis_gk_i2cc2i_create_common
#define gk_ifkvkselect                            SuiteSparse_metis_gk_ifkvkselect
#define gk_iargmax                                SuiteSparse_metis_gk_iargmax
#define gk_iargmin                                SuiteSparse_metis_gk_iargmin
#define gk_iincset                                SuiteSparse_metis_gk_iincset
#define gk_imax                                   SuiteSparse_metis_gk_imax
#define gk_imin                                   SuiteSparse_metis_gk_imin
#define gk_inorm2                                 SuiteSparse_metis_gk_inorm2
#define gk_isum                                   SuiteSparse_metis_gk_isum
#define gk_iFreeMatrix                            SuiteSparse_metis_gk_iFreeMatrix
#define gk_ikvAllocMatrix                         SuiteSparse_metis_gk_ikvAllocMatrix
#define gk_ikvcopy                                SuiteSparse_metis_gk_ikvcopy
#define gk_ikvFreeMatrix                          SuiteSparse_metis_gk_ikvFreeMatrix
#define gk_ikvmalloc                              SuiteSparse_metis_gk_ikvmalloc
#define gk_ikvrealloc                             SuiteSparse_metis_gk_ikvrealloc
#define gk_ikvset                                 SuiteSparse_metis_gk_ikvset
#define gk_ikvSetMatrix                           SuiteSparse_metis_gk_ikvSetMatrix
#define gk_ikvsmalloc                             SuiteSparse_metis_gk_ikvsmalloc
#define gk_ikvsortd                               SuiteSparse_metis_gk_ikvsortd
#define gk_ikvsorti                               SuiteSparse_metis_gk_ikvsorti
#define gk_imalloc                                SuiteSparse_metis_gk_imalloc
#define gk_ipqCheckHeap                           SuiteSparse_metis_gk_ipqCheckHeap
#define gk_ipqCreate                              SuiteSparse_metis_gk_ipqCreate
#define gk_ipqDelete                              SuiteSparse_metis_gk_ipqDelete
#define gk_ipqDestroy                             SuiteSparse_metis_gk_ipqDestroy
#define gk_ipqFree                                SuiteSparse_metis_gk_ipqFree
#define gk_ipqGetTop                              SuiteSparse_metis_gk_ipqGetTop
#define gk_ipqInit                                SuiteSparse_metis_gk_ipqInit
#define gk_ipqInsert                              SuiteSparse_metis_gk_ipqInsert
#define gk_ipqLength                              SuiteSparse_metis_gk_ipqLength
#define gk_ipqReset                               SuiteSparse_metis_gk_ipqReset
#define gk_ipqSeeKey                              SuiteSparse_metis_gk_ipqSeeKey
#define gk_ipqSeeTopKey                           SuiteSparse_metis_gk_ipqSeeTopKey
#define gk_ipqSeeTopVal                           SuiteSparse_metis_gk_ipqSeeTopVal
#define gk_ipqUpdate                              SuiteSparse_metis_gk_ipqUpdate
#define gk_irand                                  SuiteSparse_metis_gk_irand
#define gk_irandArrayPermute                      SuiteSparse_metis_gk_irandArrayPermute
#define gk_irandArrayPermuteFine                  SuiteSparse_metis_gk_irandArrayPermuteFine
#define gk_irandInRange                           SuiteSparse_metis_gk_irandInRange
#define gk_irealloc                               SuiteSparse_metis_gk_irealloc
#define gk_iscale                                 SuiteSparse_metis_gk_iscale
#define gk_iset                                   SuiteSparse_metis_gk_iset
#define gk_iSetMatrix                             SuiteSparse_metis_gk_iSetMatrix
#define gk_ismalloc                               SuiteSparse_metis_gk_ismalloc
#define gk_isortd                                 SuiteSparse_metis_gk_isortd
#define gk_isorti                                 SuiteSparse_metis_gk_isorti
#define gk_ispow2                                 SuiteSparse_metis_gk_ispow2
#define gk_isrand                                 SuiteSparse_metis_gk_isrand

#define gk_log2                                   SuiteSparse_metis_gk_log2
#define gk_malloc                                 SuiteSparse_metis_gk_malloc
#define gk_malloc_cleanup                         SuiteSparse_metis_gk_malloc_cleanup
#define gk_malloc_init                            SuiteSparse_metis_gk_malloc_init
#define gk_mcoreAdd                               SuiteSparse_metis_gk_mcoreAdd
#define gk_mcoreCreate                            SuiteSparse_metis_gk_mcoreCreate
#define gk_mcoreDel                               SuiteSparse_metis_gk_mcoreDel
#define gk_mcoreDestroy                           SuiteSparse_metis_gk_mcoreDestroy
#define gk_mcoreMalloc                            SuiteSparse_metis_gk_mcoreMalloc
#define gk_mcorePop                               SuiteSparse_metis_gk_mcorePop
#define gk_mcorePush                              SuiteSparse_metis_gk_mcorePush
#define gk_NonLocalExit_Handler                   SuiteSparse_metis_gk_NonLocalExit_Handler
#define gk_randinit                               SuiteSparse_metis_gk_randinit
#define gk_randint32                              SuiteSparse_metis_gk_randint32
#define gk_randint64                              SuiteSparse_metis_gk_randint64
#define gk_RandomPermute                          SuiteSparse_metis_gk_RandomPermute
#define gk_realloc                                SuiteSparse_metis_gk_realloc
#define gk_rw_PageRank                            SuiteSparse_metis_gk_rw_PageRank
#define gk_seq_free                               SuiteSparse_metis_gk_seq_free
#define gk_seq_init                               SuiteSparse_metis_gk_seq_init
#define gk_set_exit_on_error                      SuiteSparse_metis_gk_set_exit_on_error
#define gk_SetSignalHandlers                      SuiteSparse_metis_gk_SetSignalHandlers
#define gk_sigthrow                               SuiteSparse_metis_gk_sigthrow
#define gk_sigtrap                                SuiteSparse_metis_gk_sigtrap
#define gk_siguntrap                              SuiteSparse_metis_gk_siguntrap
#define gk_skvAllocMatrix                         SuiteSparse_metis_gk_skvAllocMatrix
#define gk_skvcopy                                SuiteSparse_metis_gk_skvcopy
#define gk_skvFreeMatrix                          SuiteSparse_metis_gk_skvFreeMatrix
#define gk_skvmalloc                              SuiteSparse_metis_gk_skvmalloc
#define gk_skvrealloc                             SuiteSparse_metis_gk_skvrealloc
#define gk_skvset                                 SuiteSparse_metis_gk_skvset
#define gk_skvSetMatrix                           SuiteSparse_metis_gk_skvSetMatrix
#define gk_skvsmalloc                             SuiteSparse_metis_gk_skvsmalloc
#define gk_skvsortd                               SuiteSparse_metis_gk_skvsortd
#define gk_skvsorti                               SuiteSparse_metis_gk_skvsorti
#define gk_strdup                                 SuiteSparse_metis_gk_strdup
#define gk_UnsetSignalHandlers                    SuiteSparse_metis_gk_UnsetSignalHandlers

#define gk_zAllocMatrix                           SuiteSparse_metis_gk_zAllocMatrix
#define gk_zargmax_n                              SuiteSparse_metis_gk_zargmax_n
#define gk_zaxpy                                  SuiteSparse_metis_gk_zaxpy
#define gk_zcopy                                  SuiteSparse_metis_gk_zcopy
#define gk_zdot                                   SuiteSparse_metis_gk_zdot
#define gk_zFreeMatrix                            SuiteSparse_metis_gk_zFreeMatrix
#define gk_zkvAllocMatrix                         SuiteSparse_metis_gk_zkvAllocMatrix
#define gk_zkvcopy                                SuiteSparse_metis_gk_zkvcopy
#define gk_zkvFreeMatrix                          SuiteSparse_metis_gk_zkvFreeMatrix
#define gk_zkvmalloc                              SuiteSparse_metis_gk_zkvmalloc
#define gk_zkvrealloc                             SuiteSparse_metis_gk_zkvrealloc
#define gk_zkvset                                 SuiteSparse_metis_gk_zkvset
#define gk_zkvSetMatrix                           SuiteSparse_metis_gk_zkvSetMatrix
#define gk_zkvsmalloc                             SuiteSparse_metis_gk_zkvsmalloc
#define gk_zkvsortd                               SuiteSparse_metis_gk_zkvsortd
#define gk_zkvsorti                               SuiteSparse_metis_gk_zkvsorti
#define gk_zmalloc                                SuiteSparse_metis_gk_zmalloc
#define gk_zrand                                  SuiteSparse_metis_gk_zrand
#define gk_zrandArrayPermute                      SuiteSparse_metis_gk_zrandArrayPermute
#define gk_zrandArrayPermuteFine                  SuiteSparse_metis_gk_zrandArrayPermuteFine
#define gk_zrandInRange                           SuiteSparse_metis_gk_zrandInRange
#define gk_zrealloc                               SuiteSparse_metis_gk_zrealloc
#define gk_zscale                                 SuiteSparse_metis_gk_zscale
#define gk_zset                                   SuiteSparse_metis_gk_zset
#define gk_zSetMatrix                             SuiteSparse_metis_gk_zSetMatrix
#define gk_zsmalloc                               SuiteSparse_metis_gk_zsmalloc
#define gk_zsrand                                 SuiteSparse_metis_gk_zsrand
#define gk_zargmax                                SuiteSparse_metis_gk_zargmax
#define gk_zargmin                                SuiteSparse_metis_gk_zargmin
#define gk_zincset                                SuiteSparse_metis_gk_zincset
#define gk_zmax                                   SuiteSparse_metis_gk_zmax
#define gk_zmin                                   SuiteSparse_metis_gk_zmin
#define gk_znorm2                                 SuiteSparse_metis_gk_znorm2
#define gk_zsum                                   SuiteSparse_metis_gk_zsum

#define GrowBisectionNode2                        SuiteSparse_metis_GrowBisectionNode2

#define HTable_Create                             SuiteSparse_metis_HTable_Create
#define HTable_Delete                             SuiteSparse_metis_HTable_Delete
#define HTable_Destroy                            SuiteSparse_metis_HTable_Destroy
#define HTable_GetNext                            SuiteSparse_metis_HTable_GetNext
#define HTable_HFunction                          SuiteSparse_metis_HTable_HFunction
#define HTable_Insert                             SuiteSparse_metis_HTable_Insert
#define HTable_Reset                              SuiteSparse_metis_HTable_Reset
#define HTable_Resize                             SuiteSparse_metis_HTable_Resize
#define HTable_Search                             SuiteSparse_metis_HTable_Search
#define HTable_SearchAndDelete                    SuiteSparse_metis_HTable_SearchAndDelete

#define itemsets_find_frequent_itemsets           SuiteSparse_metis_itemsets_find_frequent_itemsets
#define itemsets_project_matrix                   SuiteSparse_metis_itemsets_project_matrix

#define libmetis__Allocate2WayNodePartitionMemory SuiteSparse_metis_libmetis__Allocate2WayNodePartitionMemory
#define libmetis__Allocate2WayPartitionMemory     SuiteSparse_metis_libmetis__Allocate2WayPartitionMemory
#define libmetis__AllocateKWayPartitionMemory     SuiteSparse_metis_libmetis__AllocateKWayPartitionMemory
#define libmetis__AllocateRefinementWorkSpace     SuiteSparse_metis_libmetis__AllocateRefinementWorkSpace
#define libmetis__AllocateWorkSpace               SuiteSparse_metis_libmetis__AllocateWorkSpace
#define libmetis__Balance2Way                     SuiteSparse_metis_libmetis__Balance2Way
#define libmetis__BetterBalance2Way               SuiteSparse_metis_libmetis__BetterBalance2Way
#define libmetis__BetterBalanceKWay               SuiteSparse_metis_libmetis__BetterBalanceKWay
#define libmetis__BetterVBalance                  SuiteSparse_metis_libmetis__BetterVBalance
#define libmetis__Bnd2WayBalance                  SuiteSparse_metis_libmetis__Bnd2WayBalance
#define libmetis__BucketSortKeysInc               SuiteSparse_metis_libmetis__BucketSortKeysInc
#define libmetis__Change2CNumbering               SuiteSparse_metis_libmetis__Change2CNumbering
#define libmetis__Change2FNumbering               SuiteSparse_metis_libmetis__Change2FNumbering
#define libmetis__Change2FNumbering2              SuiteSparse_metis_libmetis__Change2FNumbering2
#define libmetis__Change2FNumberingOrder          SuiteSparse_metis_libmetis__Change2FNumberingOrder
#define libmetis__ChangeMesh2CNumbering           SuiteSparse_metis_libmetis__ChangeMesh2CNumbering
#define libmetis__ChangeMesh2FNumbering           SuiteSparse_metis_libmetis__ChangeMesh2FNumbering
#define libmetis__ChangeMesh2FNumbering2          SuiteSparse_metis_libmetis__ChangeMesh2FNumbering2
#define libmetis__CheckBnd                        SuiteSparse_metis_libmetis__CheckBnd
#define libmetis__CheckBnd2                       SuiteSparse_metis_libmetis__CheckBnd2
#define libmetis__CheckGraph                      SuiteSparse_metis_libmetis__CheckGraph
#define libmetis__CheckInputGraphWeights          SuiteSparse_metis_libmetis__CheckInputGraphWeights
#define libmetis__CheckKWayVolPartitionParams     SuiteSparse_metis_libmetis__CheckKWayVolPartitionParams
#define libmetis__CheckNodeBnd                    SuiteSparse_metis_libmetis__CheckNodeBnd
#define libmetis__CheckNodePartitionParams        SuiteSparse_metis_libmetis__CheckNodePartitionParams
#define libmetis__CheckParams                     SuiteSparse_metis_libmetis__CheckParams
#define libmetis__CheckRInfo                      SuiteSparse_metis_libmetis__CheckRInfo
#define libmetis__cnbrpoolGetNext                 SuiteSparse_metis_libmetis__cnbrpoolGetNext
#define libmetis__cnbrpoolReset                   SuiteSparse_metis_libmetis__cnbrpoolReset
#define libmetis__CoarsenGraph                    SuiteSparse_metis_libmetis__CoarsenGraph
#define libmetis__CompressGraph                   SuiteSparse_metis_libmetis__CompressGraph
#define libmetis__Compute2WayNodePartitionParams  SuiteSparse_metis_libmetis__Compute2WayNodePartitionParams
#define libmetis__Compute2WayPartitionParams      SuiteSparse_metis_libmetis__Compute2WayPartitionParams
#define libmetis__ComputeCut                      SuiteSparse_metis_libmetis__ComputeCut
#define libmetis__ComputeElementBalance           SuiteSparse_metis_libmetis__ComputeElementBalance
#define libmetis__ComputeKWayBoundary             SuiteSparse_metis_libmetis__ComputeKWayBoundary
#define libmetis__ComputeKWayPartitionParams      SuiteSparse_metis_libmetis__ComputeKWayPartitionParams
#define libmetis__ComputeKWayVolGains             SuiteSparse_metis_libmetis__ComputeKWayVolGains
#define libmetis__ComputeLoadImbalance            SuiteSparse_metis_libmetis__ComputeLoadImbalance
#define libmetis__ComputeLoadImbalanceDiff        SuiteSparse_metis_libmetis__ComputeLoadImbalanceDiff
#define libmetis__ComputeLoadImbalanceDiffVec     SuiteSparse_metis_libmetis__ComputeLoadImbalanceDiffVec
#define libmetis__ComputeLoadImbalanceVec         SuiteSparse_metis_libmetis__ComputeLoadImbalanceVec
#define libmetis__ComputeMaxCut                   SuiteSparse_metis_libmetis__ComputeMaxCut
#define libmetis__ComputePartitionBalance         SuiteSparse_metis_libmetis__ComputePartitionBalance
#define libmetis__ComputePartitionInfoBipartite   SuiteSparse_metis_libmetis__ComputePartitionInfoBipartite
#define libmetis__ComputeSubDomainGraph           SuiteSparse_metis_libmetis__ComputeSubDomainGraph
#define libmetis__ComputeVolume                   SuiteSparse_metis_libmetis__ComputeVolume
#define libmetis__ConstructMinCoverSeparator      SuiteSparse_metis_libmetis__ConstructMinCoverSeparator
#define libmetis__ConstructSeparator              SuiteSparse_metis_libmetis__ConstructSeparator
#define libmetis__CreateCoarseGraph               SuiteSparse_metis_libmetis__CreateCoarseGraph
#define libmetis__CreateCoarseGraphNoMask         SuiteSparse_metis_libmetis__CreateCoarseGraphNoMask
#define libmetis__CreateCoarseGraphPerm           SuiteSparse_metis_libmetis__CreateCoarseGraphPerm
#define libmetis__CreateGraph                     SuiteSparse_metis_libmetis__CreateGraph
#define libmetis__CreateGraphDual                 SuiteSparse_metis_libmetis__CreateGraphDual
#define libmetis__CreateGraphNodal                SuiteSparse_metis_libmetis__CreateGraphNodal
#define libmetis__CreateMesh                      SuiteSparse_metis_libmetis__CreateMesh
#define libmetis__EliminateComponents             SuiteSparse_metis_libmetis__EliminateComponents
#define libmetis__EliminateSubDomainEdges         SuiteSparse_metis_libmetis__EliminateSubDomainEdges
#define libmetis__FindCommonElements              SuiteSparse_metis_libmetis__FindCommonElements
#define libmetis__FindCommonNodes                 SuiteSparse_metis_libmetis__FindCommonNodes
#define libmetis__FindPartitionInducedComponents  SuiteSparse_metis_libmetis__FindPartitionInducedComponents
#define libmetis__FindSepInducedComponents        SuiteSparse_metis_libmetis__FindSepInducedComponents
#define libmetis__FixGraph                        SuiteSparse_metis_libmetis__FixGraph
#define libmetis__FM_2WayCutRefine                SuiteSparse_metis_libmetis__FM_2WayCutRefine
#define libmetis__FM_2WayNodeBalance              SuiteSparse_metis_libmetis__FM_2WayNodeBalance
#define libmetis__FM_2WayNodeRefine1Sided         SuiteSparse_metis_libmetis__FM_2WayNodeRefine1Sided
#define libmetis__FM_2WayNodeRefine1SidedP        SuiteSparse_metis_libmetis__FM_2WayNodeRefine1SidedP
#define libmetis__FM_2WayNodeRefine2Sided         SuiteSparse_metis_libmetis__FM_2WayNodeRefine2Sided
#define libmetis__FM_2WayNodeRefine2SidedP        SuiteSparse_metis_libmetis__FM_2WayNodeRefine2SidedP
#define libmetis__FM_2WayRefine                   SuiteSparse_metis_libmetis__FM_2WayRefine
#define libmetis__FM_Mc2WayCutRefine              SuiteSparse_metis_libmetis__FM_Mc2WayCutRefine
#define libmetis__FreeCtrl                        SuiteSparse_metis_libmetis__FreeCtrl
#define libmetis__FreeGraph                       SuiteSparse_metis_libmetis__FreeGraph
#define libmetis__FreeMesh                        SuiteSparse_metis_libmetis__FreeMesh
#define libmetis__FreeRData                       SuiteSparse_metis_libmetis__FreeRData
#define libmetis__FreeWorkSpace                   SuiteSparse_metis_libmetis__FreeWorkSpace
#define libmetis__General2WayBalance              SuiteSparse_metis_libmetis__General2WayBalance
#define libmetis__genmmd                          SuiteSparse_metis_libmetis__genmmd
#define libmetis__Greedy_KWayCutOptimize          SuiteSparse_metis_libmetis__Greedy_KWayCutOptimize
#define libmetis__Greedy_KWayOptimize             SuiteSparse_metis_libmetis__Greedy_KWayOptimize
#define libmetis__Greedy_KWayVolOptimize          SuiteSparse_metis_libmetis__Greedy_KWayVolOptimize
#define libmetis__Greedy_McKWayCutOptimize        SuiteSparse_metis_libmetis__Greedy_McKWayCutOptimize
#define libmetis__Greedy_McKWayVolOptimize        SuiteSparse_metis_libmetis__Greedy_McKWayVolOptimize
#define libmetis__GrowBisection                   SuiteSparse_metis_libmetis__GrowBisection
#define libmetis__GrowBisectionNode               SuiteSparse_metis_libmetis__GrowBisectionNode
#define libmetis__iAllocMatrix                    SuiteSparse_metis_libmetis__iAllocMatrix
#define libmetis__iargmax                         SuiteSparse_metis_libmetis__iargmax
#define libmetis__iargmax2_nrm                    SuiteSparse_metis_libmetis__iargmax2_nrm
#define libmetis__iargmax_n                       SuiteSparse_metis_libmetis__iargmax_n
#define libmetis__iargmax_nrm                     SuiteSparse_metis_libmetis__iargmax_nrm
#define libmetis__iargmax_strd                    SuiteSparse_metis_libmetis__iargmax_strd
#define libmetis__iargmin                         SuiteSparse_metis_libmetis__iargmin
#define libmetis__iarray2csr                      SuiteSparse_metis_libmetis__iarray2csr
#define libmetis__iaxpy                           SuiteSparse_metis_libmetis__iaxpy
#define libmetis__icopy                           SuiteSparse_metis_libmetis__icopy
#define libmetis__idot                            SuiteSparse_metis_libmetis__idot
#define libmetis__iFreeMatrix                     SuiteSparse_metis_libmetis__iFreeMatrix
#define libmetis__iincset                         SuiteSparse_metis_libmetis__iincset
#define libmetis__ikvAllocMatrix                  SuiteSparse_metis_libmetis__ikvAllocMatrix
#define libmetis__ikvcopy                         SuiteSparse_metis_libmetis__ikvcopy
#define libmetis__ikvFreeMatrix                   SuiteSparse_metis_libmetis__ikvFreeMatrix
#define libmetis__ikvmalloc                       SuiteSparse_metis_libmetis__ikvmalloc
#define libmetis__ikvrealloc                      SuiteSparse_metis_libmetis__ikvrealloc
#define libmetis__ikvset                          SuiteSparse_metis_libmetis__ikvset
#define libmetis__ikvSetMatrix                    SuiteSparse_metis_libmetis__ikvSetMatrix
#define libmetis__ikvsmalloc                      SuiteSparse_metis_libmetis__ikvsmalloc
#define libmetis__ikvsortd                        SuiteSparse_metis_libmetis__ikvsortd
#define libmetis__ikvsorti                        SuiteSparse_metis_libmetis__ikvsorti
#define libmetis__ikvsortii                       SuiteSparse_metis_libmetis__ikvsortii
#define libmetis__ikvwspacemalloc                 SuiteSparse_metis_libmetis__ikvwspacemalloc
#define libmetis__imalloc                         SuiteSparse_metis_libmetis__imalloc
#define libmetis__imax                            SuiteSparse_metis_libmetis__imax
#define libmetis__imin                            SuiteSparse_metis_libmetis__imin
#define libmetis__InduceRowPartFromColumnPart     SuiteSparse_metis_libmetis__InduceRowPartFromColumnPart
#define libmetis__Init2WayPartition               SuiteSparse_metis_libmetis__Init2WayPartition
#define libmetis__InitGraph                       SuiteSparse_metis_libmetis__InitGraph
#define libmetis__InitKWayPartitioning            SuiteSparse_metis_libmetis__InitKWayPartitioning
#define libmetis__InitMesh                        SuiteSparse_metis_libmetis__InitMesh
#define libmetis__InitRandom                      SuiteSparse_metis_libmetis__InitRandom
#define libmetis__InitSeparator                   SuiteSparse_metis_libmetis__InitSeparator
#define libmetis__InitTimers                      SuiteSparse_metis_libmetis__InitTimers
#define libmetis__inorm2                          SuiteSparse_metis_libmetis__inorm2
#define libmetis__ipqCheckHeap                    SuiteSparse_metis_libmetis__ipqCheckHeap
#define libmetis__ipqCreate                       SuiteSparse_metis_libmetis__ipqCreate
#define libmetis__ipqDelete                       SuiteSparse_metis_libmetis__ipqDelete
#define libmetis__ipqDestroy                      SuiteSparse_metis_libmetis__ipqDestroy
#define libmetis__ipqFree                         SuiteSparse_metis_libmetis__ipqFree
#define libmetis__ipqGetTop                       SuiteSparse_metis_libmetis__ipqGetTop
#define libmetis__ipqInit                         SuiteSparse_metis_libmetis__ipqInit
#define libmetis__ipqInsert                       SuiteSparse_metis_libmetis__ipqInsert
#define libmetis__ipqLength                       SuiteSparse_metis_libmetis__ipqLength
#define libmetis__ipqReset                        SuiteSparse_metis_libmetis__ipqReset
#define libmetis__ipqSeeKey                       SuiteSparse_metis_libmetis__ipqSeeKey
#define libmetis__ipqSeeTopKey                    SuiteSparse_metis_libmetis__ipqSeeTopKey
#define libmetis__ipqSeeTopVal                    SuiteSparse_metis_libmetis__ipqSeeTopVal
#define libmetis__ipqUpdate                       SuiteSparse_metis_libmetis__ipqUpdate
#define libmetis__irand                           SuiteSparse_metis_libmetis__irand
#define libmetis__irandArrayPermute               SuiteSparse_metis_libmetis__irandArrayPermute
#define libmetis__irandArrayPermuteFine           SuiteSparse_metis_libmetis__irandArrayPermuteFine
#define libmetis__irandInRange                    SuiteSparse_metis_libmetis__irandInRange
#define libmetis__irealloc                        SuiteSparse_metis_libmetis__irealloc
#define libmetis__IsArticulationNode              SuiteSparse_metis_libmetis__IsArticulationNode
#define libmetis__IsBalanced                      SuiteSparse_metis_libmetis__IsBalanced
#define libmetis__iscale                          SuiteSparse_metis_libmetis__iscale
#define libmetis__IsConnected                     SuiteSparse_metis_libmetis__IsConnected
#define libmetis__IsConnectedSubdomain            SuiteSparse_metis_libmetis__IsConnectedSubdomain
#define libmetis__iset                            SuiteSparse_metis_libmetis__iset
#define libmetis__iSetMatrix                      SuiteSparse_metis_libmetis__iSetMatrix
#define libmetis__ismalloc                        SuiteSparse_metis_libmetis__ismalloc
#define libmetis__isortd                          SuiteSparse_metis_libmetis__isortd
#define libmetis__isorti                          SuiteSparse_metis_libmetis__isorti
#define libmetis__isrand                          SuiteSparse_metis_libmetis__isrand
#define libmetis__IsSeparable                     SuiteSparse_metis_libmetis__IsSeparable
#define libmetis__isum                            SuiteSparse_metis_libmetis__isum
#define libmetis__ivecaxpygez                     SuiteSparse_metis_libmetis__ivecaxpygez
#define libmetis__ivecaxpylez                     SuiteSparse_metis_libmetis__ivecaxpylez
#define libmetis__ivecge                          SuiteSparse_metis_libmetis__ivecge
#define libmetis__ivecle                          SuiteSparse_metis_libmetis__ivecle
#define libmetis__iwspacemalloc                   SuiteSparse_metis_libmetis__iwspacemalloc
#define libmetis__KWayVolUpdate                   SuiteSparse_metis_libmetis__KWayVolUpdate
#define libmetis__Match_2Hop                      SuiteSparse_metis_libmetis__Match_2Hop
#define libmetis__Match_2HopAll                   SuiteSparse_metis_libmetis__Match_2HopAll
#define libmetis__Match_2HopAny                   SuiteSparse_metis_libmetis__Match_2HopAny
#define libmetis__Match_RM                        SuiteSparse_metis_libmetis__Match_RM
#define libmetis__Match_SHEM                      SuiteSparse_metis_libmetis__Match_SHEM
#define libmetis__McGeneral2WayBalance            SuiteSparse_metis_libmetis__McGeneral2WayBalance
#define libmetis__McGrowBisection                 SuiteSparse_metis_libmetis__McGrowBisection
#define libmetis__McRandomBisection               SuiteSparse_metis_libmetis__McRandomBisection
#define libmetis__metis_rcode                     SuiteSparse_metis_libmetis__metis_rcode
#define libmetis__MinCover                        SuiteSparse_metis_libmetis__MinCover
#define libmetis__MinCover_Augment                SuiteSparse_metis_libmetis__MinCover_Augment
#define libmetis__MinCover_ColDFS                 SuiteSparse_metis_libmetis__MinCover_ColDFS
#define libmetis__MinCover_Decompose              SuiteSparse_metis_libmetis__MinCover_Decompose
#define libmetis__MinCover_RowDFS                 SuiteSparse_metis_libmetis__MinCover_RowDFS
#define libmetis__MlevelKWayPartitioning          SuiteSparse_metis_libmetis__MlevelKWayPartitioning
#define libmetis__MlevelNestedDissection          SuiteSparse_metis_libmetis__MlevelNestedDissection
#define libmetis__MlevelNestedDissectionCC        SuiteSparse_metis_libmetis__MlevelNestedDissectionCC
#define libmetis__MlevelNestedDissectionP         SuiteSparse_metis_libmetis__MlevelNestedDissectionP
#define libmetis__MlevelNodeBisectionL1           SuiteSparse_metis_libmetis__MlevelNodeBisectionL1
#define libmetis__MlevelNodeBisectionL2           SuiteSparse_metis_libmetis__MlevelNodeBisectionL2
#define libmetis__MlevelNodeBisectionMultiple     SuiteSparse_metis_libmetis__MlevelNodeBisectionMultiple
#define libmetis__MlevelRecursiveBisection        SuiteSparse_metis_libmetis__MlevelRecursiveBisection
#define libmetis__mmdelm                          SuiteSparse_metis_libmetis__mmdelm
#define libmetis__mmdint                          SuiteSparse_metis_libmetis__mmdint
#define libmetis__mmdnum                          SuiteSparse_metis_libmetis__mmdnum
#define libmetis__MMDOrder                        SuiteSparse_metis_libmetis__MMDOrder
#define libmetis__mmdupd                          SuiteSparse_metis_libmetis__mmdupd
#define libmetis__MoveGroupContigForCut           SuiteSparse_metis_libmetis__MoveGroupContigForCut
#define libmetis__MoveGroupContigForVol           SuiteSparse_metis_libmetis__MoveGroupContigForVol
#define libmetis__MoveGroupMinConnForCut          SuiteSparse_metis_libmetis__MoveGroupMinConnForCut
#define libmetis__MoveGroupMinConnForVol          SuiteSparse_metis_libmetis__MoveGroupMinConnForVol
#define libmetis__MultilevelBisect                SuiteSparse_metis_libmetis__MultilevelBisect
#define libmetis__Print2WayRefineStats            SuiteSparse_metis_libmetis__Print2WayRefineStats
#define libmetis__PrintCGraphStats                SuiteSparse_metis_libmetis__PrintCGraphStats
#define libmetis__PrintCtrl                       SuiteSparse_metis_libmetis__PrintCtrl
#define libmetis__PrintSubDomainGraph             SuiteSparse_metis_libmetis__PrintSubDomainGraph
#define libmetis__PrintTimers                     SuiteSparse_metis_libmetis__PrintTimers
#define libmetis__Project2WayNodePartition        SuiteSparse_metis_libmetis__Project2WayNodePartition
#define libmetis__Project2WayPartition            SuiteSparse_metis_libmetis__Project2WayPartition
#define libmetis__ProjectKWayPartition            SuiteSparse_metis_libmetis__ProjectKWayPartition
#define libmetis__PruneGraph                      SuiteSparse_metis_libmetis__PruneGraph
#define libmetis__rAllocMatrix                    SuiteSparse_metis_libmetis__rAllocMatrix
#define libmetis__RandomBisection                 SuiteSparse_metis_libmetis__RandomBisection
#define libmetis__rargmax                         SuiteSparse_metis_libmetis__rargmax
#define libmetis__rargmax2                        SuiteSparse_metis_libmetis__rargmax2
#define libmetis__rargmax_n                       SuiteSparse_metis_libmetis__rargmax_n
#define libmetis__rargmin                         SuiteSparse_metis_libmetis__rargmin
#define libmetis__raxpy                           SuiteSparse_metis_libmetis__raxpy
#define libmetis__rcopy                           SuiteSparse_metis_libmetis__rcopy
#define libmetis__rdot                            SuiteSparse_metis_libmetis__rdot
#define libmetis__ReAdjustMemory                  SuiteSparse_metis_libmetis__ReAdjustMemory
#define libmetis__Refine2Way                      SuiteSparse_metis_libmetis__Refine2Way
#define libmetis__Refine2WayNode                  SuiteSparse_metis_libmetis__Refine2WayNode
#define libmetis__RefineKWay                      SuiteSparse_metis_libmetis__RefineKWay
#define libmetis__rFreeMatrix                     SuiteSparse_metis_libmetis__rFreeMatrix
#define libmetis__rincset                         SuiteSparse_metis_libmetis__rincset
#define libmetis__rkvAllocMatrix                  SuiteSparse_metis_libmetis__rkvAllocMatrix
#define libmetis__rkvcopy                         SuiteSparse_metis_libmetis__rkvcopy
#define libmetis__rkvFreeMatrix                   SuiteSparse_metis_libmetis__rkvFreeMatrix
#define libmetis__rkvmalloc                       SuiteSparse_metis_libmetis__rkvmalloc
#define libmetis__rkvrealloc                      SuiteSparse_metis_libmetis__rkvrealloc
#define libmetis__rkvset                          SuiteSparse_metis_libmetis__rkvset
#define libmetis__rkvSetMatrix                    SuiteSparse_metis_libmetis__rkvSetMatrix
#define libmetis__rkvsmalloc                      SuiteSparse_metis_libmetis__rkvsmalloc
#define libmetis__rkvsortd                        SuiteSparse_metis_libmetis__rkvsortd
#define libmetis__rkvsorti                        SuiteSparse_metis_libmetis__rkvsorti
#define libmetis__rmalloc                         SuiteSparse_metis_libmetis__rmalloc
#define libmetis__rmax                            SuiteSparse_metis_libmetis__rmax
#define libmetis__rmin                            SuiteSparse_metis_libmetis__rmin
#define libmetis__rnorm2                          SuiteSparse_metis_libmetis__rnorm2
#define libmetis__rpqCheckHeap                    SuiteSparse_metis_libmetis__rpqCheckHeap
#define libmetis__rpqCreate                       SuiteSparse_metis_libmetis__rpqCreate
#define libmetis__rpqDelete                       SuiteSparse_metis_libmetis__rpqDelete
#define libmetis__rpqDestroy                      SuiteSparse_metis_libmetis__rpqDestroy
#define libmetis__rpqFree                         SuiteSparse_metis_libmetis__rpqFree
#define libmetis__rpqGetTop                       SuiteSparse_metis_libmetis__rpqGetTop
#define libmetis__rpqInit                         SuiteSparse_metis_libmetis__rpqInit
#define libmetis__rpqInsert                       SuiteSparse_metis_libmetis__rpqInsert
#define libmetis__rpqLength                       SuiteSparse_metis_libmetis__rpqLength
#define libmetis__rpqReset                        SuiteSparse_metis_libmetis__rpqReset
#define libmetis__rpqSeeKey                       SuiteSparse_metis_libmetis__rpqSeeKey
#define libmetis__rpqSeeTopKey                    SuiteSparse_metis_libmetis__rpqSeeTopKey
#define libmetis__rpqSeeTopVal                    SuiteSparse_metis_libmetis__rpqSeeTopVal
#define libmetis__rpqUpdate                       SuiteSparse_metis_libmetis__rpqUpdate
#define libmetis__rrealloc                        SuiteSparse_metis_libmetis__rrealloc
#define libmetis__rscale                          SuiteSparse_metis_libmetis__rscale
#define libmetis__rset                            SuiteSparse_metis_libmetis__rset
#define libmetis__rSetMatrix                      SuiteSparse_metis_libmetis__rSetMatrix
#define libmetis__rsmalloc                        SuiteSparse_metis_libmetis__rsmalloc
#define libmetis__rsortd                          SuiteSparse_metis_libmetis__rsortd
#define libmetis__rsorti                          SuiteSparse_metis_libmetis__rsorti
#define libmetis__rsum                            SuiteSparse_metis_libmetis__rsum
#define libmetis__rvecge                          SuiteSparse_metis_libmetis__rvecge
#define libmetis__rvecle                          SuiteSparse_metis_libmetis__rvecle
#define libmetis__rvecmaxdiff                     SuiteSparse_metis_libmetis__rvecmaxdiff
#define libmetis__rvecsumle                       SuiteSparse_metis_libmetis__rvecsumle
#define libmetis__rwspacemalloc                   SuiteSparse_metis_libmetis__rwspacemalloc
#define libmetis__SelectQueue                     SuiteSparse_metis_libmetis__SelectQueue
#define libmetis__Setup2WayBalMultipliers         SuiteSparse_metis_libmetis__Setup2WayBalMultipliers
#define libmetis__SetupCoarseGraph                SuiteSparse_metis_libmetis__SetupCoarseGraph
#define libmetis__SetupCtrl                       SuiteSparse_metis_libmetis__SetupCtrl
#define libmetis__SetupGraph                      SuiteSparse_metis_libmetis__SetupGraph
#define libmetis__SetupGraph_label                SuiteSparse_metis_libmetis__SetupGraph_label
#define libmetis__SetupGraph_tvwgt                SuiteSparse_metis_libmetis__SetupGraph_tvwgt
#define libmetis__SetupKWayBalMultipliers         SuiteSparse_metis_libmetis__SetupKWayBalMultipliers
#define libmetis__SetupSplitGraph                 SuiteSparse_metis_libmetis__SetupSplitGraph
#define libmetis__SplitGraphOrder                 SuiteSparse_metis_libmetis__SplitGraphOrder
#define libmetis__SplitGraphOrderCC               SuiteSparse_metis_libmetis__SplitGraphOrderCC
#define libmetis__SplitGraphPart                  SuiteSparse_metis_libmetis__SplitGraphPart
#define libmetis__UpdateEdgeSubDomainGraph        SuiteSparse_metis_libmetis__UpdateEdgeSubDomainGraph
#define libmetis__uvwsorti                        SuiteSparse_metis_libmetis__uvwsorti
#define libmetis__vnbrpoolGetNext                 SuiteSparse_metis_libmetis__vnbrpoolGetNext
#define libmetis__vnbrpoolReset                   SuiteSparse_metis_libmetis__vnbrpoolReset
#define libmetis__wspacemalloc                    SuiteSparse_metis_libmetis__wspacemalloc
#define libmetis__wspacepop                       SuiteSparse_metis_libmetis__wspacepop
#define libmetis__wspacepush                      SuiteSparse_metis_libmetis__wspacepush

#define METIS_ComputeVertexSeparator              SuiteSparse_metis_METIS_ComputeVertexSeparator
#define METIS_Free                                SuiteSparse_metis_METIS_Free
#define METIS_MeshToDual                          SuiteSparse_metis_METIS_MeshToDual
#define METIS_MeshToNodal                         SuiteSparse_metis_METIS_MeshToNodal
#define METIS_NodeND                              SuiteSparse_metis_METIS_NodeND
#define METIS_NodeNDP                             SuiteSparse_metis_METIS_NodeNDP
#define METIS_NodeRefine                          SuiteSparse_metis_METIS_NodeRefine
#define METIS_PartGraphKway                       SuiteSparse_metis_METIS_PartGraphKway
#define METIS_PartGraphRecursive                  SuiteSparse_metis_METIS_PartGraphRecursive
#define METIS_PartMeshDual                        SuiteSparse_metis_METIS_PartMeshDual
#define METIS_PartMeshNodal                       SuiteSparse_metis_METIS_PartMeshNodal
#define METIS_SetDefaultOptions                   SuiteSparse_metis_METIS_SetDefaultOptions

#define PrintBackTrace                            SuiteSparse_metis_PrintBackTrace

#include "SuiteSparse_metis/GKlib/GKlib.h"
#include "SuiteSparse_metis/include/metis.h"

#if (IDXTYPEWIDTH != 64)
#error "SuiteSparse requires the 64-bit version of METIS 5.1.0 (with IDXTYPEWIDTH set to 64)"
#endif

#endif
